package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS034-微信刷脸支付调用凭证请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayWechatFacePayAuthRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 门店编号
     * 必填: 是
     * 长度: 32
     * 说明: 门店编号，由商户定义，各门店唯一
     */
    @NotBlank(message = "门店编号不能为空")
    private String storeid;

    /**
     * 门店名称
     * 必填: 是
     * 长度: 128
     * 说明: 门店名称，由商户定义。（可用于展示）
     */
    @NotBlank(message = "门店名称不能为空")
    private String storename;

    /**
     * 终端设备编号
     * 必填: 是
     * 长度: 32
     * 说明: 终端设备编号，由商户定义
     */
    @NotBlank(message = "终端设备编号不能为空")
    private String deviceid;

    /**
     * 附加字段
     * 必填: 否
     * 说明: 附加字段。字段格式使用Json
     */
    private String attach;

    /**
     * 初始化数据
     * 必填: 是
     * 长度: 2048
     * 说明: 初始化数据。由微信人脸SDK的接口返回
     */
    @NotBlank(message = "初始化数据不能为空")
    private String rawdata;

    /**
     * Appid
     * 必填: 否
     * 长度: 32
     * 说明: 子商户绑定的公众号/小程序 appid
     */
    private String subappid;
}
