package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * @author songjian * @version MsfpayEnterpriseRequest.java, v 0.1 2025-08-06 19:39 songjian
 */
@Data
public class MsfpayEnterpriseRequest {
    /**
     * 签约手机号
     * 必填: 是
     * 长度: 11
     */
    public String phone;

    /**
     * 会员名称
     * 必填: 是
     * 长度: 64
     */
    public String custname;

    /**
     * 会员类型
     * 必填: 是
     * 长度: 1
     * 说明: 2企业
     */
    public String usertype;

    /**
     * 证件类型
     * 必填: 是
     * 长度: 3
     * 说明: 101 营业执照 105 登记证书
     */
    public String custcerttype;

    /**
     * 证件号码
     * 必填: 是
     * 长度: 22
     */
    public String custcertno;

    /**
     * 证件照片
     * 必填: 是
     * 长度: 128
     */
    public String busphotourl;

    /**
     * 经营地址省编码
     * 必填: 是
     * 长度: 6
     */
    public String busprocode;

    /**
     * 经营地址市编码
     * 必填: 是
     * 长度: 6
     */
    public String buscitycode;

    /**
     * 经营地址区县编码
     * 必填: 是
     * 长度: 6
     */
    public String busregioncode;

    /**
     * 经营地址详细地址
     * 必填: 是
     * 长度: 128
     */
    public String busadd;

    /**
     * 法人姓名
     * 必填: 是
     * 长度: 64
     */
    public String name;

    /**
     * 法人身份证正面照片
     * 必填: 是
     * 长度: 128
     */
    public String idfrontimgurl;

    /**
     * 法人身份证反面照片
     * 必填: 是
     * 长度: 128
     */
    public String idbackimgurl;

    /**
     * 法人证件类型
     * 必填: 是
     * 长度: 64
     * 说明: 0 身份证 2 护照 5港澳居民来往内地通行证 6台湾同胞来往内地通行证
     */
    public String certtype;

    /**
     * 法人证件号码
     * 必填: 是
     * 长度: 22
     */
    public String certno;

    /**
     * 法人证件有效期开始
     * 必填: 是
     * 长度: 8
     * 格式: yyyyMMdd
     */
    public String signdate;

    /**
     * 法人证件有效期截止
     * 必填: 是
     * 长度: 64
     * 格式: yyyyMMdd
     */
    public String certdate;

    /**
     * 法人证件地址省编码
     * 必填: 否
     * 长度: 6
     */
    public String procode;

    /**
     * 法人证件地址市编码
     * 必填: 否
     * 长度: 64
     */
    public String citycode;

    /**
     * 法人证件地址区县编码
     * 必填: 否
     * 长度: 64
     */
    public String regioncode;

    /**
     * 法人证件地址详细地址
     * 必填: 是
     * 长度: 64
     */
    public String address;

    /**
     * 银行卡类型
     * 必填: 是
     * 长度: 2
     * 说明: 99 企业账户
     */
    public String bankcardtype;

    /**
     * 银行卡号
     * 必填: 是
     * 长度: 32
     */
    public String bankcardno;

    /**
     * 银行编码
     * 必填: 是
     * 长度: 12
     */
    public String bankcode;

    /**
     * 开户省编码
     * 必填: 是
     * 长度: 6
     */
    public String openprocode;

    /**
     * 开户市编码
     * 必填: 是
     * 长度: 6
     */
    public String opencitycode;

    /**
     * 银行账户开户证明文件
     * 必填: 是
     * 长度: 128
     * 说明: 具体开户证明文件可登录"中投科信支付"公众号-常见问题中查阅
     */
    public String bankcardimgurl;

    /**
     * 开户声明文件
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持图片，(法定代表人亲笔签名+加盖公章)原件；附《开户声明文件模板》
     */
    public String declareimgurl;

    /**
     * 开户意愿视频
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持mp4、mov视频格式，文件不大于10M；法定代表人在《开户声明》上签字的视频文件
     */
    public String wishvdourl;
}
