/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 机具报备接口 response
 *
 * @author
 * @version LzccbDeviceRegisterRes.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbDeviceRegisterRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555609803390L;

    /**
     * 设备报备号，最大长度8
     * (必填)
     */
    @NotBlank
    private String deviceNo;

    /**
     * 机具序列号，最大长度32
     * (必填)
     */
    @NotBlank
    private String deviceSn;

    /**
     * 微信报备状态，最大长度32
     * (必填)
     */
    @NotBlank
    private String wexinStatus;

    /**
     * 微信报备消息，最大长度32
     * (必填)
     */
    @NotBlank
    private String wexinMsg;

    /**
     * 支付宝报备状态，最大长度32
     * (必填)
     */
    @NotBlank
    private String aliStatus;

    /**
     * 支付宝报备消息，最大长度32
     * (必填)
     */
    @NotBlank
    private String aliMsg;

    /**
     * 银联报备状态，最大长度32
     * (必填)
     */
    @NotBlank
    private String unionSttaus;

    /**
     * 银联报备消息，最大长度32
     * (必填)
     */
    @NotBlank
    private String unionMsg;

}