/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbDeviceRegisterReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555817760615L;


    /**
     * 机具序列号，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "deviceSn长度不能超过32")
    private String deviceSn;

    /**
     * 终端类型，最大长度10
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "deviceType长度不能超过10")
    private String deviceType;

    /**
     * 绑定商户号，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 绑定门店号，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeNo长度不能超过32")
    private String storeNo;

    /**
     * 渠道商编号，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "channelNo长度不能超过32")
    private String channelNo;

}