/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 余额与待清算金额查询接口 response
 *
 * @author
 * @version LzccbBalanceQueryRes.java, v 0.1 2024-09-11 16:41:33
 */
@Data
public class LzccbBalanceQueryRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555689426894L;


    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    private String merchantNo;

    /**
     * 商户可用余额（元），最大长度32
     * (必填)
     */
    @NotBlank
    private String balance;

    /**
     * 商户待清算金额（元），最大长度32
     * (必填)
     */
    @NotBlank
    private String waitSettAmount;

}