package com.fshows.apienum;

import com.fshows.request.LzccbBalanceQueryReq;
import com.fshows.request.LzccbDeviceRegisterReq;
import com.fshows.request.LzccbGetSm4KeyReq;
import com.fshows.request.LzccbJsApiPayReq;
import com.fshows.request.LzccbOrderQueryReq;
import com.fshows.request.LzccbRefundApplyReq;
import com.fshows.request.LzccbUnifiedOrderCreateReq;
import com.fshows.response.LzccbBalanceQueryRes;
import com.fshows.response.LzccbDeviceRegisterRes;
import com.fshows.response.LzccbGetSm4KeyRes;
import com.fshows.response.LzccbJsApiPayRes;
import com.fshows.response.LzccbOrderQueryRes;
import com.fshows.response.LzccbRefundApplyRes;
import com.fshows.response.LzccbUnifiedOrderCreateRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 泸州银行相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LzccbApiDefinitionEnum implements IApiDefinition {

    UNIFIED_ORDER_CREATE(
            "统一下单接口",
            "/payGateway/zlxt/trade/pay",
            "1.0.0",
            "TRADE",
            LzccbUnifiedOrderCreateReq.class,
            LzccbUnifiedOrderCreateRes.class
    ),
    JSAPI_PAY(
            "微信公众号/支付宝H5下单",
            "/payGateway/zlxt/trade/getPublicPayParams",
            "1.0.0",
            "TRADE",
            LzccbJsApiPayReq.class,
            LzccbJsApiPayRes.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "/payGateway/payApi/merchant/trade/queryOrder",
            "1.0.0",
            "TRADE",
            LzccbOrderQueryReq.class,
            LzccbOrderQueryRes.class
    ),
    REFUND_APPLY(
            "退款接口",
            "/payGateway/zlxt/trade/refund",
            "1.0.0",
            "TRADE",
            LzccbRefundApplyReq.class,
            LzccbRefundApplyRes.class
    ),
    BALANCE_QUERY(
            "余额与待清算金额查询接口",
            "/payGateway/payApi/query/account",
            "1.0.0",
            "TRADE",
            LzccbBalanceQueryReq.class,
            LzccbBalanceQueryRes.class
    ),
    DEVICE_REGISTER(
            "机具报备接口",
            "/payGateway/channel/DeviceRegiste",
            "1.0.0",
            "MERCHANT",
            LzccbDeviceRegisterReq.class,
            LzccbDeviceRegisterRes.class
    ),
    GET_SM4_KEY(
            "获取sm4密钥",
            "/payGateway/payApi/merchant/getSm4Key",
            "1.0.0",
            "COMMON",
            LzccbGetSm4KeyReq.class,
            LzccbGetSm4KeyRes.class
    )
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     *  MERCHANT - 商户接口
     *  TRADE  -  交易接口
     *  COMMON  - 通用接口
     */
    private String interfaceType;


    LzccbApiDefinitionEnum(String name,
                           String apiSubURI,
                           String version,
                           String interfaceType,
                           Class requestClass,
                           Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}