package com.fshows.llmcode.base.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 拉卡拉文档中的类型枚举
 *
 * @author liluqing
 * @version UmpayFieldTypeEunm.java, v 0.1 2022-03-06 21:59 liluqing
 */
public enum UmpayFieldTypeEunm {

    STRING("", "String", "String"),
    PRICE("", "Price", "BigDecimal"),
    DIGINTEGER("", "Diginteger", "BigDecimal"),
    BigDecimal("", "BigDecimal", "BigDecimal"),
    INT("", "int", "Integer"),
    INTEGER("", "Integer", "Integer"),
    NUMBER("", "Number", "Integer"),
    UNKNOW("", "unknow", "unknow"),
    JSON("", "json", "String"),
    A("", "A", "String"),
    ;

    private String name;
    private String value;
    private String javaType;

    /**
     * Getter method for property <tt>javaType</tt>.
     *
     * @return property value of javaType
     */
    public String getJavaType() {
        return javaType;
    }

    UmpayFieldTypeEunm(String name, String value, String javaType) {
        this.name = name;
        this.value = value;
        this.javaType = javaType;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static UmpayFieldTypeEunm getByValue(String value) {
        UmpayFieldTypeEunm[] valueList = UmpayFieldTypeEunm.values();
        for (UmpayFieldTypeEunm v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return UNKNOW;
    }
}