package com.fshows.lifecircle.service.utils;

import com.fshows.lifecircle.service.utils.domain.Tuple2;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Objects;

/**
 *
 */
public class OssFileUtils {

    public static Tuple2<String,String> invert(String ossFile) {

        String bucketName=null;
        String key=null;

        if (Objects.isNull(ossFile) || ossFile.startsWith("http")){
            return new Tuple2<>(null,null);
        }


        if (ossFile.startsWith("/")){
            ossFile=ossFile.substring(1);
        }

        String[] split = ossFile.split("/");
        if (split.length >= 2) {
            // bucketName="1/2"
            // key="3" 其余格式不符合
            bucketName = split[0];
            key = Arrays.asList(split).stream().skip(1).reduce(null, (a, b) -> {
                        if (a == null) {
                            return b;
                        } else {
                            return a + "/" + b;
                        }
                    }
            );

            return new Tuple2(bucketName,key);
        }else {
            return Tuple2.of(null,null);
        }

    }

    public static void main(String[] args) {
        Tuple2<String, String> invert = invert("/saledian/lifeCircle/imgs/logo/bank/little/little_bank_logo_jiaotong.png");
        System.out.println(invert.f0);
        System.out.println(invert.f1);
        System.out.print((String) invert.getField(0));


        String o="/saledian/lifeCircle/imgs/logo/bank/little/little_bank_logo_jiaotong.png";

    }
}
