/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.utils.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fshows.lifecircle.service.utils.domain.BizResponseCodeEnum;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;

@JsonIgnoreProperties(value={"success"})
public class BizResponse<T> {
    private String resultCode;
    private String errorCode;
    private String errorMessage;
    private T data;

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static BizResponse serverError() {
        BizResponse response = new BizResponse();
        response.setResultCode(BizResponseCodeEnum.FAIL.str());
        ErrorCodeEnum serverError = ErrorCodeEnum.SERVER_ERROR;
        response.setErrorCode(serverError.getCode());
        response.setErrorMessage(serverError.getMsg());
        return response;
    }

    public static BizResponse paramsError(String paramName) {
        BizResponse response = new BizResponse();
        response.setResultCode(BizResponseCodeEnum.FAIL.str());
        ErrorCodeEnum invalidParameter = ErrorCodeEnum.INVALID_PARAMETER;
        response.setErrorCode(invalidParameter.getCode());
        response.setErrorMessage(invalidParameter.getMsg() + (paramName != null ? paramName : ""));
        return response;
    }

    public static BizResponse fail(String errorCode, String errorMsg) {
        BizResponse response = new BizResponse();
        response.setResultCode(BizResponseCodeEnum.FAIL.str());
        response.setErrorCode(errorCode);
        response.setErrorMessage(errorMsg);
        return response;
    }

    public static <T> BizResponse success(T data) {
        BizResponse<T> response = new BizResponse<T>();
        response.setResultCode(BizResponseCodeEnum.SUCCESS.str());
        response.setData(data);
        return response;
    }

    public Boolean isSuccess() {
        return "SUCCESS".equals(this.resultCode);
    }

    public String toString() {
        return "BizResponse{resultCode='" + this.resultCode + '\'' + ", errorCode='" + this.errorCode + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", data=" + this.data + '}';
    }
}

