/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpringNullNotCopyBeanUtils
extends BeanUtils {
    public static void copyProperties(Object source, Object target, Boolean ignoreNullCopy, Class<?> editable, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = SpringNullNotCopyBeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        PropertyDescriptor[] var7 = targetPds;
        int var8 = targetPds.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = var7[var9];
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = SpringNullNotCopyBeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                if (!Objects.nonNull(value)) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
                continue;
            }
            catch (Throwable var15) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", var15);
            }
        }
    }
}

