/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOSSUtil {
    private static final Logger log = LoggerFactory.getLogger(AliOSSUtil.class);

    public static boolean uploadFile(String bucketName, String key, String filename, OSSClient ossClient) {
        try {
            File file = new File(filename);
            FileInputStream input = new FileInputStream(file);
            ossClient.putObject(bucketName, key, (InputStream)input);
            ossClient.shutdown();
            return true;
        }
        catch (Exception e) {
            log.error("AliOSSUtil ---- >> uploadFile \u4e0a\u4f20\u5f02\u5e38, e = {}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
            ossClient.shutdown();
            return false;
        }
    }

    public static void downloadFile(String bucketName, String key, String filename, OSSClient ossClient) {
        try {
            ossClient.getObject(new GetObjectRequest(bucketName, key), new File(filename));
            ossClient.shutdown();
        }
        catch (Exception e) {
            log.error("AliOSSUtil ---- >> downloadFile \u4e0b\u8f7d\u5f02\u5e38, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            ossClient.shutdown();
        }
    }

    public static String fileUrl(String bucketName, String key, OSSClient ossClient) {
        String downloadUrl = "";
        try {
            Date time = new Date(System.currentTimeMillis() + 3600000L);
            URL url = ossClient.generatePresignedUrl(bucketName, key, time);
            downloadUrl = url.toString();
            ossClient.shutdown();
            return downloadUrl;
        }
        catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl \u4e0b\u8f7d\u5730\u5740\u5f02\u5e38, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return downloadUrl;
        }
    }
}

