/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.utils;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@ThreadSafe
public class DateUtil {
    public static String formatDate(Date date) {
        return DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(date);
    }

    public static String formatDateTime(Date date) {
        return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date formatDateTime(String yyyy_MM_dd) throws ParseException {
        return FastDateFormat.getInstance((String)"yyyy-MM-dd").parse(yyyy_MM_dd);
    }

    public static Long formatDateTimeMillions(String yyyy_MM_dd) throws ParseException {
        return DateUtil.formatDateTime(yyyy_MM_dd).getTime();
    }

    public static Date beginOfToday() {
        return new DateTime().withTimeAtStartOfDay().toDate();
    }

    public static Date endfTOfday() {
        return new DateTime().withTimeAtStartOfDay().plusDays(1).minusMillis(1).toDate();
    }

    public static Date beginOfMonth() {
        return new DateTime().withTimeAtStartOfDay().withDayOfMonth(1).toDate();
    }

    public static Date endOfMonth() {
        return new DateTime().withTimeAtStartOfDay().plusMonths(1).withDayOfMonth(1).minusMillis(1).toDate();
    }

    @Deprecated
    public static String formatDate(Date date, String newFormat) {
        if (date == null || newFormat == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(newFormat);
        return formatter.format(date);
    }

    public static boolean dateCompare(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        try {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(d1);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(d2);
            long p1 = c1.getTimeInMillis();
            long p2 = c2.getTimeInMillis();
            if (p1 > p2) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String getNowDateTimeStr() {
        return DateTime.now().toString("yyyyMMddHHmmss");
    }

    public static String getNowDateStr() {
        return DateTime.now().toString("yyyyMMdd");
    }

    public static int getNowDate() {
        return Integer.valueOf(DateTime.now().toString("yyyyMMdd"));
    }

    public static int getYesterdayDate() {
        return Integer.valueOf(DateTime.now().plusDays(-1).toString("yyyyMMdd"));
    }

    public static String getNowDateFormat() {
        return DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public static String getNowDateFormat(String format) {
        return DateTime.now().toString(format);
    }

    public static long getNow() {
        return DateTime.now().getMillis();
    }

    public static Date getTimeByHours(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, hours);
        return calendar.getTime();
    }

    public static boolean isScopeByThreeMonth(Integer createDay) {
        Integer today = Integer.valueOf(DateTime.now().toString("yyyyMMdd"));
        Integer threeMonth = Integer.valueOf(DateTime.now().plusMonths(-3).toString("yyyyMMdd"));
        return createDay >= threeMonth && createDay < today;
    }

    public static boolean isScopeByThreeMonthAndToday(Integer createDay) {
        Integer today = Integer.valueOf(DateTime.now().toString("yyyyMMdd"));
        Integer threeMonth = Integer.valueOf(DateTime.now().plusMonths(-3).toString("yyyyMMdd"));
        return createDay >= threeMonth && createDay <= today;
    }

    public static long formatMillis(String time, String formatType) {
        SimpleDateFormat format = new SimpleDateFormat(formatType);
        try {
            Date date = format.parse(time);
            return date.getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static long getMillisByString(String time, String forMate) {
        return DateTimeFormat.forPattern((String)forMate).parseDateTime(time).getMillis();
    }

    public static long getMillisByString(String time) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd").parseDateTime(time).getMillis();
    }

    public static String getStringByMillis(long millis, String formatType) {
        return new DateTime(millis).toString(formatType);
    }

    public static Map<String, Long> getCurrentStartAndEnd() {
        return DateUtil.getStartAndEndByDay(DateTime.now().toString("yyyyMMdd"));
    }

    public static Map<String, Long> getYesterdayStartAndEnd() {
        return DateUtil.getStartAndEndByDay(DateTime.now().plusDays(-1).toString("yyyyMMdd"));
    }

    public static Map<String, Long> getStartAndEndByDay(String day) {
        DateTime dayTime = DateTime.parse((String)day, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyyMMdd"));
        long startTime = dayTime.withTimeAtStartOfDay().getMillis();
        long endTime = dayTime.plusDays(1).withTimeAtStartOfDay().getMillis();
        HashMap params = Maps.newHashMap();
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        return params;
    }

    public static String getYYYYMM(String yyyyMMdd) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        String ym = "";
        try {
            ym = df.format(sdf.parse(yyyyMMdd));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ym;
    }

    public static int getDateByOrderSn(String orderSn) {
        String date = orderSn.substring(0, 8);
        return Integer.valueOf(DateTimeFormat.forPattern((String)"yyyyMMdd").parseDateTime(date).toString("yyyyMMdd"));
    }

    public static boolean isInTime(long startTime, long endTime) {
        long nowTime = DateTime.now().getMillis();
        return nowTime >= startTime && nowTime <= endTime;
    }

    public static boolean isInTimeForHours(int startHours, int endHours) {
        DateTime now = DateTime.now();
        long startTime = now.withTimeAtStartOfDay().withHourOfDay(startHours).getMillis();
        long endTime = now.withTimeAtStartOfDay().withHourOfDay(endHours).getMillis();
        return DateUtil.isInTime(startTime, endTime);
    }

    public static boolean isInTime9to21() {
        DateTime now = DateTime.now().withTimeAtStartOfDay();
        long startTime = now.withHourOfDay(9).getMillis();
        long endTime = now.withHourOfDay(21).getMillis();
        return DateUtil.isInTime(startTime, endTime);
    }

    public static String unionpayQrValidTime() {
        DateTime now = DateTime.now();
        if (now.getHourOfDay() >= 23) {
            return "0";
        }
        DateTime end = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss").parseDateTime(now.toString("yyyyMMdd") + "230000");
        int d = end.getSecondOfDay() - now.getSecondOfDay();
        d = d < 0 ? 0 : d;
        return String.valueOf(d);
    }

    public static String unionpayQrValidTime(Integer day) {
        DateTime now = DateTime.now();
        if (now.getHourOfDay() >= 23) {
            return "0";
        }
        DateTime end = now.plusDays(day.intValue());
        long d = (end.getMillis() - now.getMillis()) / 1000L;
        d = d < 0L ? 0L : d;
        return String.valueOf(d);
    }

    public static void main(String[] args) throws ParseException {
        Date date = DateUtil.formatDateTime("2017-12-01");
        Long aLong = DateUtil.formatDateTimeMillions("2017-12-01");
        System.out.println(date);
    }
}

