/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.utils;

import java.util.*;

/**
 * @author spafka
 * 流的安全构造
 */
public class OptionalUtils {


    public static <T> List<T> safeListStream(List<T> coll) {

        return Optional.ofNullable(coll).orElse(new ArrayList<>());

    }

    public static <K, V> Map<K, V> safeMapStream(Map<K, V> coll) {

        return Optional.ofNullable(coll).orElse(new HashMap<K, V>());

    }


    public static <T> T  safe(T t,Class<T> clazz){
        try {
            return Optional.ofNullable(t).orElse(clazz.newInstance() );
        } catch (InstantiationException e) {
            e.printStackTrace();

        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {

        List<String> a = new LinkedList<>();
        a.add("1");

        List<String> strings = safeListStream(a);
        strings.stream().forEach(System.out::println);

        safeListStream(a).stream().map(x -> new RuntimeException());

    }
}

