package com.fshows.lifecircle.service.utils.domain;

/**
 * 项目：lifecircle-business-advertising
 * 包名：com.fshows.lifecircle.business.advertising.openapi.facade.domain.result
 * 功能：
 * 创建时间：2017-09-28 11:01
 * 更新记录：
 * @author ：BuHao
 */
public enum ErrorCodeEnum {

  /**
   * 数据操作失败
   */
  DATA_OPERATION_FAILURE("DATA_OPERATION_FAILURE", "数据操作失败"),
  /**
   * 无效参数
   */
  INVALID_PARAMETER("INVALID_PARAMETER", "无效参数"),
  /**
   * 服务器错误
   */
  SERVER_ERROR("SERVER_ERROR", "服务器错误"),
  /**
   * 请求方法错误
   */
  REQUEST_METHOD_ERROR("REQUEST_METHOD_ERROR", "请求方法错误"),
  /**
   * 媒体类型不支持
   */
  MEDIA_NOT_SUPPORT_ERROR("MEDIA_NOT_SUPPORT_ERROR", "媒体类型不支持"),

  /**
   * 短信验证码错误
   */
  SMS_TOKEN_ERROR("SMS_TOKEN_ERROR","短信验证码错误");




  /**
   * 错误码
   */
  private String code;
  /**
   * 错误信息
   */
  private String msg;

  ErrorCodeEnum(String code, String msg) {
    this.code = code;
    this.msg = msg;
  }

  /**
   * 获得错误码
   * @return
   */
  public String getCode() {
    return this.code;
  }

  /**
   * 获得错误信息
   * @return
   */
  public String getMsg() {
    return this.msg;
  }
}
