/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fshows.lifecircle.service.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 项目：lifecircle-business-user
 * 包名：com.fshows.lifecircle.business.utils
 * 功能：
 * 创建时间：2017-10-16 16:02
 * 更新记录：
 * @author ：BuHao
 */
public class CollectionUtils {

  public static  <T> Set<T> diff(Set<T> set1, Set<T> set2){

    HashSet<T> resultSet = new HashSet<>();
    HashSet<T> tempSet = new HashSet<>();

    tempSet.addAll(set1);
    tempSet.removeAll(set2);

    resultSet.addAll(tempSet);

    tempSet.clear();

    tempSet.addAll(set2);
    tempSet.removeAll(set1);

    resultSet.addAll(tempSet);

    return resultSet;
  }

  /**
   * Returns an empty collection if this list is null
   * @param other
   * @return
   */
  public static <T> List<T> safe(List<T> other) {
    return other == null ? Collections.emptyList() : other;
  }

}
