/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.utils.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 项目：lifecircle-business-advertise
 * 包名：com.fshows.lifecircle.business.advertise.business.model.common
 * 功能：业务返回对象
 * 创建时间：2017-09-26 15:21
 * 更新记录：
 * @author ：BuHao
 */
@JsonIgnoreProperties({"success"})
public class BizResponse<T> {

  private String resultCode;
  private String errorCode;
  private String errorMessage;

  private T data;

  public String getResultCode() {
    return resultCode;
  }

  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }

  public String getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public T getData() {
    return data;
  }

  public void setData(T data) {
    this.data = data;
  }

  /**
   * 服务器错误
   * @return
   */
  public static BizResponse serverError(){

    BizResponse<Object> response = new BizResponse<>();
    response.setResultCode(BizResponseCodeEnum.FAIL.str());
    ErrorCodeEnum serverError = ErrorCodeEnum.SERVER_ERROR;
    response.setErrorCode(serverError.getCode());
    response.setErrorMessage(serverError.getMsg());

    return response;
  }

  /**
   * 无效参数
   * @param paramName 参数名
   * @return
   */
  public static BizResponse paramsError(String paramName){

    BizResponse<Object> response = new BizResponse<>();
    response.setResultCode(BizResponseCodeEnum.FAIL.str());
    ErrorCodeEnum invalidParameter = ErrorCodeEnum.INVALID_PARAMETER;
    response.setErrorCode(invalidParameter.getCode());
    response.setErrorMessage(invalidParameter.getMsg() + (paramName != null ? paramName : ""));

    return response;
  }

  /**
   * 业务执行失败
   * @return
   */
  public static BizResponse fail(String errorCode, String errorMsg){

    BizResponse<Object> response = new BizResponse<>();
    response.setResultCode(BizResponseCodeEnum. FAIL.str());
    response.setErrorCode(errorCode);
    response.setErrorMessage(errorMsg);

    return response;
  }

  /**
   * 调用成功返回
   * @param data
   * @return
   */
  public static <T> BizResponse success(T data){

    BizResponse<T> response = new BizResponse<>();
    response.setResultCode(BizResponseCodeEnum.SUCCESS.str());
    response.setData(data);

    return response;
  }

  /**
   * 是否成功
   * @return
   */
  public Boolean isSuccess(){

    return "SUCCESS".equals(this.resultCode);
  }

  @Override
  public String toString() {
    return "BizResponse{" +
        "resultCode='" + resultCode + '\'' +
        ", errorCode='" + errorCode + '\'' +
        ", errorMessage='" + errorMessage + '\'' +
        ", data=" + data +
        '}';
  }
}
