/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.utils.domain;

/**
 * 项目：lifecircle-service-advertise
 * 包名：com.fshows.lifecircle.service.advertise.core.model.common
 * 功能：接口请求返回对象
 * 创建时间：2017-09-26 15:15
 * 更新记录：
 *
 * @author ：BuHao
 */
public class ApiResult<T> {

  private Integer resultCode;
  private Integer errorCode;
  private String errorMessage;
  private BizResponse<T> bizResponse;


  /**
   * 参数错误
   */
  public static ApiResult paramsError(String msg) {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.INVALID_PARAMETER.value());
    apiResult.setErrorMessage(ErrorCode.INVALID_PARAMETER.str() + " >> " + msg);

    return apiResult;
  }


  /**
   * 请求方法错误
   */
  public static ApiResult requestMethodError(String msg) {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.REQUEST_METHOD_ERROR.value());
    apiResult.setErrorMessage(msg);

    return apiResult;
  }

  /**
   * 媒体类型不支持
   */
  public static ApiResult mediaNoSupportError(String msg) {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.MEDIA_NOT_SUPPORT_ERROR.value());
    apiResult.setErrorMessage(msg);

    return apiResult;
  }

  /**
   * 请求地址错误
   */
  public static ApiResult requestUrlError(String msg) {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.PATH_NOT_FOUND.value());
    apiResult.setErrorMessage(msg);

    return apiResult;
  }

  /**
   * 登录失效
   */
  public static ApiResult loginFailure() {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.LOGIN_FAILURE.value());
    apiResult.setErrorMessage(ErrorCode.LOGIN_FAILURE.str());

    return apiResult;
  }

  /**
   * 请求成功
   */
  public static ApiResult success(Object data) {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.SUCCESS.value());
    apiResult.setBizResponse(BizResponse.success(data));

    return apiResult;
  }

  /**
   * 通讯成功，业务失败
   */
  public static ApiResult success(String bizErrorCode, String bizErrorMsg) {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.SUCCESS.value());
    apiResult.setBizResponse(BizResponse.fail(bizErrorCode, bizErrorMsg));

    return apiResult;
  }

  /**
   * 请求方法错误
   */
  public static ApiResult serverError() {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.SERVER_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.SERVER_RPC_ERROR.value());
    apiResult.setErrorMessage(ErrorCode.SERVER_RPC_ERROR.str());

    return apiResult;
  }


  /**
   * 签名错误
   */
  public static ApiResult signError() {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.SIGN_ERROR.value());
    apiResult.setErrorMessage(ErrorCode.SIGN_ERROR.str());

    return apiResult;
  }

  /**
   * 权限错误
   */
  public static ApiResult authError() {

    ApiResult apiResult = new ApiResult();
    apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
    apiResult.setErrorCode(ErrorCode.PERMISSION_DENIED.value());
    apiResult.setErrorMessage(ErrorCode.PERMISSION_DENIED.str());

    return apiResult;
  }

  public Integer getResultCode() {
    return resultCode;
  }

  public void setResultCode(Integer resultCode) {
    this.resultCode = resultCode;
  }

  public Integer getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(Integer errorCode) {
    this.errorCode = errorCode;
  }

  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public BizResponse<T> getBizResponse() {
    return bizResponse;
  }

  public void setBizResponse(BizResponse<T> bizResponse) {
    this.bizResponse = bizResponse;
  }
}
