/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.utils;

import java.util.Collection;
import java.util.Iterator;

public class StringUtils {


    /**
     * Create a string from a collection
     *
     * @param coll      the collection
     * @param separator the separator
     */
    public static <T> String mkString(Collection<T> coll, String separator) {
        StringBuilder sb = new StringBuilder();
        if (coll == null) {
            return "";
        }

        Iterator<T> iter = coll.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());

            while (iter.hasNext()) {
                sb.append(separator);
                sb.append(iter.next().toString());
            }
        }
        return sb.toString();
    }

    /**
     * Create a string from a collection
     *
     * @param coll the collection
     */
    public static <T> String mkString(Collection<T> coll) {

        return mkString(coll, ",");
    }
}
