/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.utils.domain;

import com.fshows.lifecircle.service.utils.domain.ApiResultCode;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCode;

public class ApiResult<T> {
    private Integer resultCode;
    private Integer errorCode;
    private String errorMessage;
    private BizResponse<T> bizResponse;

    public static ApiResult paramsError(String msg) {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
        apiResult.setErrorCode(ErrorCode.INVALID_PARAMETER.value());
        apiResult.setErrorMessage(ErrorCode.INVALID_PARAMETER.str() + " >> " + msg);
        return apiResult;
    }

    public static ApiResult requestMethodError(String msg) {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
        apiResult.setErrorCode(ErrorCode.REQUEST_METHOD_ERROR.value());
        apiResult.setErrorMessage(msg);
        return apiResult;
    }

    public static ApiResult mediaNoSupportError(String msg) {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
        apiResult.setErrorCode(ErrorCode.MEDIA_NOT_SUPPORT_ERROR.value());
        apiResult.setErrorMessage(msg);
        return apiResult;
    }

    public static ApiResult requestUrlError(String msg) {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
        apiResult.setErrorCode(ErrorCode.PATH_NOT_FOUND.value());
        apiResult.setErrorMessage(msg);
        return apiResult;
    }

    public static ApiResult loginFailure() {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.CLIENT_FAILURE.value());
        apiResult.setErrorCode(ErrorCode.LOGIN_FAILURE.value());
        apiResult.setErrorMessage(ErrorCode.LOGIN_FAILURE.str());
        return apiResult;
    }

    public static ApiResult success(Object data) {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.SUCCESS.value());
        apiResult.setBizResponse(BizResponse.success(data));
        return apiResult;
    }

    public static ApiResult success(String bizErrorCode, String bizErrorMsg) {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.SUCCESS.value());
        apiResult.setBizResponse(BizResponse.fail(bizErrorCode, bizErrorMsg));
        return apiResult;
    }

    public static ApiResult serverError() {
        ApiResult apiResult = new ApiResult();
        apiResult.setResultCode(ApiResultCode.SERVER_FAILURE.value());
        apiResult.setErrorCode(ErrorCode.SERVER_RPC_ERROR.value());
        apiResult.setErrorMessage(ErrorCode.SERVER_RPC_ERROR.str());
        return apiResult;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public BizResponse<T> getBizResponse() {
        return this.bizResponse;
    }

    public void setBizResponse(BizResponse<T> bizResponse) {
        this.bizResponse = bizResponse;
    }
}

