/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantChildrenRoleRightControlService;
import com.fshows.lifecircle.user.service.dao.FbMerchantChildrenRoleRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantChildrenRoleMapper;
import com.fshows.lifecircle.user.service.domain.po.FbMerchantChildrenRoleRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FbMerchantChildrenRoleRightControlServiceImpl
extends ServiceImpl<FbMerchantChildrenRoleRightControlMapper, FbMerchantChildrenRoleRightControl>
implements IFbMerchantChildrenRoleRightControlService {
    private static final Logger log = LoggerFactory.getLogger(FbMerchantChildrenRoleRightControlServiceImpl.class);
    @Autowired
    private FbMerchantChildrenRoleRightControlMapper fbMerchantChildrenRoleRightControlMapper;
    @Autowired
    private FbUserMerchantChildrenRoleMapper fbUserMerchantChildrenRoleMapper;

    @Override
    public BizResponse<Boolean> updateMerchantChildrenRoleRightControl(Long roleId, String[] array) {
        log.info("updateMerchantChildrenRoleRightControl execute >> roleId={}, array = {}", (Object)roleId, (Object)array);
        try {
            FbUserMerchantChildrenRole fbUserMerchantChildrenRole = new FbUserMerchantChildrenRole();
            fbUserMerchantChildrenRole.setRoleId(roleId);
            fbUserMerchantChildrenRole = (FbUserMerchantChildrenRole)this.fbUserMerchantChildrenRoleMapper.selectOne((Object)fbUserMerchantChildrenRole);
            if (roleId == null || array == null || fbUserMerchantChildrenRole == null) {
                log.info("2.3.9 - 1, updateOemRightControl check fail, userId or array can not be null");
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            List controlList = this.fbMerchantChildrenRoleRightControlMapper.selectCountByRoleId(roleId);
            log.info("2.3.9 - 2, updateMerchantRightControl \u5b58\u50a8\u5386\u53f2\u6570\u636e fbAgentRightControlList = {}", (Object)JSON.toJSONString((Object)controlList));
            if (controlList.size() > 0) {
                this.fbMerchantChildrenRoleRightControlMapper.deleteByRoleId(roleId);
            }
            Integer i = 0;
            for (String s : array) {
                FbMerchantChildrenRoleRightControl obj = new FbMerchantChildrenRoleRightControl();
                long businessUniqId = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.CONTROL_KEY);
                obj.setId(Long.valueOf(businessUniqId));
                obj.setRoleId(roleId);
                obj.setRightKey(s);
                obj.setIsOpen(Integer.valueOf(1));
                Integer addResultCount = this.fbMerchantChildrenRoleRightControlMapper.insert((Object)obj);
                i = i + addResultCount;
            }
            if (i != array.length) {
                this.fbMerchantChildrenRoleRightControlMapper.deleteByRoleId(roleId);
                if (controlList != null && controlList.size() > 0) {
                    for (FbMerchantChildrenRoleRightControl control : controlList) {
                        this.fbMerchantChildrenRoleRightControlMapper.insert((Object)control);
                    }
                }
                return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }
            return BizResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("2.3.9 - 3, \u65b9\u6cd5: updateMerchantRightControl \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: userId = {}, array = {},\u5f02\u5e38: Ex = {}", new Object[]{roleId, array, ExceptionUtils.getStackTrace((Throwable)e)});
            return BizResponse.serverError();
        }
    }
}

