/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantChildDetailsResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantChildQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantChildrenDetailDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantChildrenResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.app.StaffListParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffListResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildren;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserMerchantChildrenServiceImpl
implements IUserMerchantChildrenService {
    private static final Logger log = LoggerFactory.getLogger(UserMerchantChildrenServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbUserMerchantChildrenService fbUserMerchantChildrenService;
    @Autowired
    private IFbUserMerchantChildrenRoleService fbUserMerchantChildrenRoleService;
    @Autowired
    private IUserBaseService userBaseService;
    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    @Override
    public BizResponse<Boolean> addUserMerchantChildren(UserMerchantChildrenParam param) {
        String username = param.getUsername();
        UserBaseParam userBaseParam = new UserBaseParam();
        userBaseParam.setUsername(username);
        userBaseParam.setUserpwd(param.getUserpwd());
        userBaseParam.setMobile(param.getMobile());
        userBaseParam.setUserType(UserType.MERCHANT.getValue());
        userBaseParam.setIsChild(Integer.valueOf(1));
        BizResponse<UserBaseResult> response = this.userBaseService.addUserBase(userBaseParam);
        if (!response.isSuccess().booleanValue()) {
            return BizResponse.fail((String)response.getErrorCode(), (String)response.getErrorMessage());
        }
        Long baseId = ((UserBaseResult)response.getData()).getBaseId();
        FbUserMerchantChildren obj = new FbUserMerchantChildren();
        BeanUtils.copyProperties((Object)param, (Object)obj);
        obj.setBaseId(baseId);
        boolean result = this.fbUserMerchantChildrenService.insert(obj);
        if (result) {
            return BizResponse.success((Object)Boolean.TRUE);
        }
        this.fbUserBaseService.delete(Condition.create().eq("base_id", (Object)param.getBaseId()));
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse<Boolean> updateUserMerchantChildren(UserMerchantChildrenParam param) {
        FbUserMerchantChildren obj = new FbUserMerchantChildren();
        BeanUtils.copyProperties((Object)param, (Object)obj);
        if (param.getBaseId() == null || param.getBaseId() <= 0L) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        UserBaseParam userBaseParam = new UserBaseParam();
        userBaseParam.setBaseId(param.getBaseId());
        userBaseParam.setUsername(param.getUsername());
        userBaseParam.setUserpwd(param.getUserpwd());
        userBaseParam.setMobile(param.getMobile());
        userBaseParam.setUserType(UserType.MERCHANT.getValue());
        this.userBaseService.updateUserBase(userBaseParam);
        this.fbUserMerchantChildrenService.update(obj, Condition.create().eq("base_id", (Object)param.getBaseId()));
        return BizResponse.success((Object)Boolean.TRUE);
    }

    @Override
    public BizResponse<MerchantChildDetailsResult> getUserMerchantChild(MerchantChildQueryParam param) {
        boolean b;
        boolean bl = b = Objects.nonNull(param.getOemId()) || Objects.nonNull(param.getBaseId());
        if (!b) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbUserMerchantChildren merchantChildren = (FbUserMerchantChildren)this.fbUserMerchantChildrenService.selectOne(new EntityWrapper().eq(Objects.nonNull(param.getBaseId()), "base_id", (Object)param.getBaseId()).like(StringUtils.isNotBlank((CharSequence)param.getLinkMan()), "linkman", param.getLinkMan()).eq(Objects.nonNull(param.getOemId()), "oem_id", (Object)param.getOemId()));
        if (!Objects.nonNull(merchantChildren)) {
            return BizResponse.success(null);
        }
        FbUserBase fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(Condition.create().eq("base_id", (Object)merchantChildren.getBaseId()));
        MerchantChildDetailsResult detailsResult = new MerchantChildDetailsResult();
        BijectionUtils.invert((Object)merchantChildren, detailsResult);
        BijectionUtils.invert((Object)fbUserBase, detailsResult);
        return BizResponse.success((Object)detailsResult);
    }

    @Override
    public BizResponse<Boolean> deleteUserMerchantChildrenByBaseId(Long baseId) {
        FbUserBase userBaseParam = new FbUserBase();
        userBaseParam.setIsDel(Integer.valueOf(1));
        userBaseParam.setBaseId(baseId);
        this.fbUserBaseService.update(userBaseParam, Condition.create().eq("base_id", (Object)baseId));
        FbUserMerchantChildren obj = new FbUserMerchantChildren();
        obj.setBaseId(baseId);
        obj.setIsDel(Integer.valueOf(1));
        this.fbUserMerchantChildrenService.update(obj, Condition.create().eq("base_id", (Object)baseId));
        return BizResponse.success((Object)Boolean.TRUE);
    }

    @Override
    public BizResponse<MerchantChildrenDetailDTO> getUserMerchantChildrenByBaseId(Long baseId) {
        MerchantChildrenDetailDTO merchantChildrenDetailDTO = new MerchantChildrenDetailDTO();
        FbUserMerchantChildren fbUserMerchantChildren = (FbUserMerchantChildren)this.fbUserMerchantChildrenService.selectOne(Condition.create().eq("base_id", (Object)baseId));
        MerchantChildrenResult merchantChildrenResult = (MerchantChildrenResult)BijectionUtils.invert((Object)fbUserMerchantChildren, MerchantChildrenResult.class);
        if (merchantChildrenResult != null) {
            FbUserBase fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(Condition.create().eq("base_id", (Object)merchantChildrenResult.getBaseId()));
            BaseInfo baseInfo = (BaseInfo)BijectionUtils.invert((Object)fbUserBase, BaseInfo.class);
            merchantChildrenDetailDTO.setBaseInfo(baseInfo);
        }
        merchantChildrenDetailDTO.setMerchantChildrenResult(merchantChildrenResult);
        return BizResponse.success((Object)merchantChildrenDetailDTO);
    }

    @Override
    public BizResponse<PageResult<StaffListResult>> getStaffListResult(StaffListParam param) {
        PageResult<StaffListResult> staffListQueries = this.fbUserMerchantChildrenService.getStaffListResult(param);
        return BizResponse.success(staffListQueries);
    }

    @Override
    public BizResponse<StaffDetailResult> getStaffDetailResult(Long uid) {
        StaffDetailResult staffDetailResult = this.fbUserMerchantChildrenService.getStaffDetailResult(uid);
        return BizResponse.success((Object)staffDetailResult);
    }
}

