/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbRegisterDisallowService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.business.utils.UserUtils;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBaseServiceImpl
implements IUserBaseService {
    private static final Logger log = LoggerFactory.getLogger(UserBaseServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbRegisterDisallowService registerDisallowService;

    @Override
    public BizResponse<UserBaseResult> addUserBase(UserBaseParam param) {
        UserBaseResult userBaseResult = new UserBaseResult();
        log.info("1, addUserBase execute >> para={}", (Object)JSON.toJSONString((Object)param));
        try {
            if (this.isDisallow(param.getUsername())) {
                return BizResponse.fail((String)ErrorCodeEnum.USERNAME_HAS_DISALLOW.getCode(), (String)ErrorCodeEnum.USERNAME_HAS_DISALLOW.getMsg());
            }
            int count = this.fbUserBaseService.selectCount(Condition.create().eq("username", (Object)param.getUsername()));
            if (count > 0) {
                log.info("1, addUserBase username exist >> usernanme={}", (Object)param.getUsername());
                return BizResponse.fail((String)ErrorCodeEnum.USER_HAS_EXIST.getCode(), (String)ErrorCodeEnum.USER_HAS_EXIST.getMsg());
            }
            FbUserBase obj = new FbUserBase();
            BeanUtils.copyProperties((Object)param, (Object)obj);
            long baseId = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.BASE_USER_KEY);
            obj.setBaseId(Long.valueOf(baseId));
            String salt = UserUtils.generatorSalt();
            String userMd5Pwd = SecureUtil.md5((String)(param.getUserpwd() + salt));
            obj.setUserpwd(userMd5Pwd);
            obj.setSalt(salt);
            obj.setStatus(Integer.valueOf(1));
            boolean addResult = this.fbUserBaseService.insert(obj);
            if (addResult) {
                userBaseResult.setBaseId(Long.valueOf(baseId));
                log.info("2, addUserBase success >> para={}", (Object)JSON.toJSONString((Object)param));
                return BizResponse.success((Object)userBaseResult);
            }
            log.info("3, addUserBase fail >> para={}", (Object)JSON.toJSONString((Object)param));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: addUserBase \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: userBaseParam = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)param), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<Boolean> updateUserBase(UserBaseParam param) {
        log.info("1, updateUserBase execute >> para={}", (Object)JSON.toJSONString((Object)param));
        long baseId = param.getBaseId();
        try {
            boolean updateResult;
            if (this.isDisallow(param.getUsername())) {
                return BizResponse.fail((String)ErrorCodeEnum.USERNAME_HAS_DISALLOW.getCode(), (String)ErrorCodeEnum.USERNAME_HAS_DISALLOW.getMsg());
            }
            int count = this.fbUserBaseService.selectCount(Condition.create().eq("username", (Object)param.getUsername()).ne("base_id", (Object)baseId));
            if (count > 0) {
                log.info("1, updateUserBase username exist >> usernanme={}", (Object)param.getUsername());
                return BizResponse.fail((String)ErrorCodeEnum.USER_HAS_EXIST.getCode(), (String)ErrorCodeEnum.USER_HAS_EXIST.getMsg());
            }
            FbUserBase obj = new FbUserBase();
            BeanUtils.copyProperties((Object)param, (Object)obj);
            if (StringUtils.isNotBlank((CharSequence)param.getUserpwd())) {
                String salt = UserUtils.generatorSalt();
                String userMd5Pwd = SecureUtil.md5((String)(param.getUserpwd() + salt));
                obj.setUserpwd(userMd5Pwd);
                obj.setSalt(salt);
            }
            if (updateResult = this.fbUserBaseService.update(obj, Condition.create().eq("base_id", (Object)baseId))) {
                log.info("2, updateUserBase success >> para={}", (Object)JSON.toJSONString((Object)param));
                return BizResponse.success((Object)Boolean.TRUE);
            }
            log.info("3, addUserBase fail >> para={}", (Object)JSON.toJSONString((Object)param));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: updateUserBase \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: userBaseParam = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)param), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<Boolean> deleteUserBase(Long baseId) {
        log.info("1, deleteUserBase execute >> baseId={}", (Object)baseId);
        try {
            FbUserBase obj = new FbUserBase();
            obj.setIsDel(Integer.valueOf(1));
            obj.setBaseId(baseId);
            boolean result = this.fbUserBaseService.update(obj, Condition.create().eq("base_id", (Object)baseId));
            if (result) {
                log.info("2, deleteUserBase success >> baseId={}", (Object)baseId);
                return BizResponse.success((Object)Boolean.TRUE);
            }
            log.info("3, deleteUserBase fail >> baseId={}", (Object)baseId);
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: deleteUserBase \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: baseId = {} ,\u5f02\u5e38: Ex = {}", (Object)baseId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<BaseInfo> getUserBaseByUsername(String username) {
        FbUserBase fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(Condition.create().eq("username", (Object)username));
        BaseInfo baseInfo = (BaseInfo)BijectionUtils.invert((Object)fbUserBase, BaseInfo.class);
        return BizResponse.success((Object)baseInfo);
    }

    @Override
    public BizResponse<BaseInfo> getUserBaseByBaseId(Long baseId) {
        try {
            FbUserBase fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(Condition.create().eq("base_id", (Object)baseId));
            BaseInfo baseInfo = (BaseInfo)BijectionUtils.invert((Object)fbUserBase, BaseInfo.class);
            return BizResponse.success((Object)baseInfo);
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: getUserBaseByBaseId \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: baseId = {} ,\u5f02\u5e38: Ex = {}", (Object)baseId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    private boolean isDisallow(String userName) {
        int count = this.registerDisallowService.selectCount(Condition.create().eq("name", (Object)userName));
        return count > 0;
    }
}

