/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentAdminIndexResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentDetailDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentQuery;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentSimpleResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentUserAndBelongResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.UserAgentResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.DateUtil;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbUserAgentMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserAgent;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.google.common.collect.Lists;
import com.xiaoleilu.hutool.util.BeanUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAgentServiceImpl
implements IUserAgentService {
    private static final Logger log = LoggerFactory.getLogger(UserAgentServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private FbUserAgentMapper fbUserAgentMapper;
    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    @Override
    public BizResponse<UserAgentResult> addUserAgent(UserAgentParam param) {
        UserAgentResult userAgentResult = new UserAgentResult();
        log.info("1, addUserAgent execute >> para={}", (Object)JSON.toJSONString((Object)param));
        try {
            boolean addResult;
            if (param.getBaseId() == null || param.getOemId() == null) {
                log.info("1.1, addUserAgent check fail, baseId or oemId can not be null");
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            FbUserAgent obj = new FbUserAgent();
            BeanUtils.copyProperties((Object)param, (Object)obj);
            long baseId = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.AGENT_USER_KEY);
            obj.setAgentId(Long.valueOf(baseId));
            if (param.getStatus() == null) {
                obj.setStatus(Integer.valueOf(0));
            }
            if (addResult = this.fbUserAgentService.insert(obj)) {
                userAgentResult.setAgentId(obj.getAgentId());
                log.info("2, addUserAgent success >> para={}", (Object)JSON.toJSONString((Object)param));
                return BizResponse.success((Object)userAgentResult);
            }
            log.info("3, addUserAgent fail >> para={}", (Object)JSON.toJSONString((Object)param));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: addUserAgent \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: param = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)param), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            boolean deleteResult = this.fbUserBaseService.delete(Condition.create().eq("base_id", (Object)param.getBaseId()));
            log.info("delete userbase deleteResult = {}, baseId = {}", (Object)deleteResult, (Object)param.getBaseId());
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<Boolean> updateUserAgent(UserAgentParam param) {
        log.info("1, updateUserAgent execute >> para={}", (Object)JSON.toJSONString((Object)param));
        if (param.getAgentId() == null) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        long agentId = param.getAgentId();
        try {
            FbUserAgent obj = new FbUserAgent();
            BeanUtils.copyProperties((Object)param, (Object)obj);
            boolean updateResult = this.fbUserAgentService.update(obj, Condition.create().eq("agent_id", (Object)agentId));
            if (updateResult) {
                log.info("2, updateUserAgent success >> para={}", (Object)JSON.toJSONString((Object)param));
                return BizResponse.success((Object)Boolean.TRUE);
            }
            log.info("3, updateUserBase fail >> para={}", (Object)JSON.toJSONString((Object)param));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: updateUserAgent \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: param = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)param), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<Boolean> auditUserAgent(Long agentId, int checkStatus, String remark) {
        log.info("1, auditUserAgent execute >> agentId={}, checkStatus={}", (Object)agentId, (Object)checkStatus);
        if (agentId == null) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        try {
            FbUserAgent obj = new FbUserAgent();
            obj.setAgentId(agentId);
            obj.setCheckStatus(Integer.valueOf(checkStatus));
            obj.setCheckTime(Long.valueOf(System.currentTimeMillis()));
            obj.setRemark(remark);
            this.fbUserAgentService.update(obj, Condition.create().eq("agent_id", (Object)agentId));
            log.info("2, auditUserAgent succrss >> agentId={}, checkStatus={}", (Object)agentId, (Object)checkStatus);
            return BizResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: auditUserAgent \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: agentId = {} ,\u5f02\u5e38: Ex = {}", (Object)agentId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<AgentDetailDTO> queryUserAgentByAgentId(Long agentId) {
        AgentDetailDTO agentDetailDTO = new AgentDetailDTO();
        FbUserAgent fbUserAgent = (FbUserAgent)this.fbUserAgentService.selectOne(Condition.create().eq("agent_id", (Object)agentId));
        AgentInfo agentInfo = (AgentInfo)BijectionUtils.invert((Object)fbUserAgent, AgentInfo.class);
        if (agentInfo != null) {
            FbUserBase fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(Condition.create().eq("base_id", (Object)agentInfo.getBaseId()));
            BaseInfo baseInfo = (BaseInfo)BijectionUtils.invert((Object)fbUserBase, BaseInfo.class);
            agentDetailDTO.setBaseInfo(baseInfo);
        }
        agentDetailDTO.setAgentInfo(agentInfo);
        return BizResponse.success((Object)agentDetailDTO);
    }

    @Override
    public BizResponse<PageResult<UserAgentDTO>> queryUserAgentPage(AgentQuery agentQuery) {
        Map map = BeanUtil.beanToMap((Object)agentQuery);
        int startNum = (agentQuery.getPage() - 1) * agentQuery.getPageSize();
        if (agentQuery.isExpireFlag()) {
            map.put("expire", agentQuery.isExpire() ? "yes" : "no");
        } else {
            map.put("expire", "all");
        }
        map.put("startNum", startNum);
        map.put("grant", "no");
        List list = this.fbUserAgentMapper.queryUserAgentPage(map);
        int totalNum = this.fbUserAgentMapper.countUserAgentByCondition(map);
        List<UserAgentDTO> targetList = BijectionUtils.invertList(list, UserAgentDTO.class);
        PageResult pageResult = new PageResult(Integer.valueOf(totalNum), targetList);
        return BizResponse.success((Object)pageResult);
    }

    @Override
    public BizResponse<PageResult<UserAgentDTO>> queryUserAgentGrantPage(AgentQuery agentQuery) {
        Map map = BeanUtil.beanToMap((Object)agentQuery);
        int startNum = (agentQuery.getPage() - 1) * agentQuery.getPageSize();
        if (agentQuery.isExpireFlag()) {
            map.put("expire", agentQuery.isExpire() ? "yes" : "no");
        } else {
            map.put("expire", "all");
        }
        map.put("startNum", startNum);
        map.put("grant", "yes");
        List list = this.fbUserAgentMapper.queryUserAgentPage(map);
        int totalNum = this.fbUserAgentMapper.countUserAgentByCondition(map);
        List<UserAgentDTO> targetList = BijectionUtils.invertList(list, UserAgentDTO.class);
        for (UserAgentDTO grant : targetList) {
            if (grant.getBelong() != null && grant.getBelong() > 0L) {
                FbUserAgent fbUserAgent = (FbUserAgent)this.fbUserAgentService.selectOne(Condition.create().eq("agent_id", (Object)grant.getBelong()));
                grant.setBelongAgentName(fbUserAgent.getCompany());
            } else {
                grant.setBelongAgentName("");
            }
            int yesterdayMerchantTotalNum = this.fbUserMerchantMapper.selectVaildMerchantCount(grant.getAgentId());
            HashMap<String, Object> yesterdayMap = new HashMap<String, Object>();
            yesterdayMap.put("agentId", grant.getAgentId());
            yesterdayMap.put("startTime", DateTime.now().plusDays(-1).toString("yyyy-MM-dd"));
            yesterdayMap.put("endTime", DateTime.now().toString("yyyy-MM-dd"));
            int merchantTotalNum = this.fbUserMerchantMapper.countYesterdayMerchant(yesterdayMap);
            grant.setYesterdayMerchantTotalNum(yesterdayMerchantTotalNum);
            grant.setMerchantTotalNum(merchantTotalNum);
        }
        PageResult pageResult = new PageResult(Integer.valueOf(totalNum), targetList);
        return BizResponse.success((Object)pageResult);
    }

    @Override
    public BizResponse<AgentUserAndBelongResult> queryUserAgentNameAndBelongAgengName(Long agentId) {
        Map map = this.fbUserAgentMapper.queryUserAgentNameAndBelongAgengName(agentId);
        AgentUserAndBelongResult result = BijectionUtils.mapToObject(map, AgentUserAndBelongResult.class);
        return BizResponse.success((Object)result);
    }

    @Override
    public BizResponse<Boolean> existByCompany(String company) {
        int count = this.fbUserAgentService.selectCount(Condition.create().eq("company", (Object)company));
        if (count > 0) {
            return BizResponse.success((Object)Boolean.TRUE);
        }
        return BizResponse.success((Object)Boolean.FALSE);
    }

    @Override
    public BizResponse<List<AgentSimpleResult>> getAllAgentListByOemId(Long oemId) {
        List sourceList = this.fbUserAgentService.selectList(Condition.create().eq("oem_id", (Object)oemId).eq("status", (Object)1).gt("vip_time", (Object)System.currentTimeMillis()));
        List<AgentSimpleResult> targetList = BijectionUtils.invertList(sourceList, AgentSimpleResult.class);
        return BizResponse.success(targetList);
    }

    @Override
    public BizResponse<AgentAdminIndexResult> statisticData(Long agentId) {
        Date date = new Date();
        int toDayAccountNum = this.fbUserMerchantService.selectCount(new EntityWrapper().and("agent_id", new Object[]{agentId}).between("create_time", (Object)DateUtil.beginOfToday(), (Object)date));
        int toYearAccountNum = this.fbUserMerchantService.selectCount(new EntityWrapper().and("agent_id", new Object[]{agentId}).between("create_time", (Object)DateUtil.beginOfToday(), (Object)date));
        int sumMerchantNum = this.fbUserMerchantService.selectCount(new EntityWrapper().and("agent_id", new Object[]{agentId}));
        int putawayShopNum = this.fbUserMerchantMapper.selectVaildMerchantCount(agentId);
        AgentAdminIndexResult indexResult = AgentAdminIndexResult.builder().toDayAccountNum(Integer.valueOf(toDayAccountNum)).toYearAccountNum(Integer.valueOf(toYearAccountNum)).sumMerchantNum(Integer.valueOf(sumMerchantNum)).putawayShopNum(Integer.valueOf(putawayShopNum)).yesterdayPayNum(BigDecimal.ZERO).toYearPayNum(BigDecimal.ZERO).build();
        return BizResponse.success((Object)indexResult);
    }

    @Override
    public List<AgentSimpleResult> getAllGrantListByAgentId(Long agentId) {
        List fbUserAgents = this.fbUserAgentService.selectList(new EntityWrapper().eq("belong", (Object)agentId));
        if (fbUserAgents != null) {
            return fbUserAgents.stream().map(agent -> AgentSimpleResult.builder().agentId(agent.getAgentId()).company(agent.getCompany()).build()).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

