/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindInfoSavaParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindRecordSaveParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantBankBindSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindInfoWithAuthResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindRecoredResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantBankBindDetailLists;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IBankBindService;
import com.fshows.lifecircle.user.service.business.db.IFbBankBindInfoService;
import com.fshows.lifecircle.user.service.business.db.IFbBankBindRecordService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbBankBindInfoMapper;
import com.fshows.lifecircle.user.service.domain.po.FbBankBindInfo;
import com.fshows.lifecircle.user.service.domain.po.FbBankBindRecord;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankBindServiceImpl
implements IBankBindService {
    private static final Logger log = LoggerFactory.getLogger(BankBindServiceImpl.class);
    @Autowired
    IFbBankBindRecordService bankBindRecordService;
    @Autowired
    IFbBankBindInfoService bankBindInfoService;
    @Autowired
    FbBankBindInfoMapper bankBindInfoMapper;

    @Override
    public BizResponse<Boolean> saveBankBindRecord(BankBindRecordSaveParam param) {
        FbBankBindRecord record = (FbBankBindRecord)BijectionUtils.invert((Object)param, FbBankBindRecord.class);
        if (Objects.isNull(record) || Objects.isNull(record.getBankId()) || Objects.isNull(record.getBankName()) || Objects.isNull(record.getBindStatus()) || Objects.isNull(record.getCardNo()) || Objects.isNull(record.getMid())) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        this.bankBindRecordService.insert(record);
        return BizResponse.success((Object)true);
    }

    @Override
    public BizResponse<Boolean> saveBankBindInfo(BankBindInfoSavaParam param) {
        FbBankBindInfo bankBindInfo = (FbBankBindInfo)BijectionUtils.invert((Object)param, FbBankBindInfo.class);
        if (Objects.isNull(bankBindInfo) || Objects.isNull(bankBindInfo.getBankId()) || StringUtils.isBlank((CharSequence)bankBindInfo.getBankName()) || Objects.isNull(bankBindInfo.getMid()) || StringUtils.isBlank((CharSequence)bankBindInfo.getBankNo()) || StringUtils.isBlank((CharSequence)bankBindInfo.getAcctId())) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        Long bindId = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.COMMON_KEY);
        bankBindInfo.setBindId(bindId);
        this.bankBindInfoService.insert(bankBindInfo);
        return BizResponse.success((Object)true);
    }

    @Override
    public BizResponse<PageResult<MerchantBankBindDetailLists>> merchantBankBindDetailList(MerchantBankBindSearchParam param) {
        Map<String, Object> paramMap = BijectionUtils.bean2Map(param);
        paramMap.put("startNum", (param.getPage() - 1) * param.getPageSize());
        List retMap = this.bankBindInfoMapper.merchantBankBindDetailList(paramMap);
        Integer count = this.bankBindInfoMapper.merchantBankBindDetailListCount(paramMap);
        List<MerchantBankBindDetailLists> ret = BijectionUtils.mapsToObjects(retMap, MerchantBankBindDetailLists.class);
        PageResult result = new PageResult(count, ret);
        return BizResponse.success((Object)result);
    }

    @Override
    public BizResponse<BankBindInfoWithAuthResult> getBindInfoByMId(Long mid) {
        Map retMap = this.bankBindInfoMapper.getAuthAndBindInfoByMId(mid);
        BankBindInfoWithAuthResult result = BijectionUtils.mapToObject(retMap, BankBindInfoWithAuthResult.class);
        return BizResponse.success((Object)result);
    }

    @Override
    public BizResponse<PageResult<BankBindRecoredResult>> getBankBindRecord(Long mid, Integer page, Integer pageSize) {
        if (Objects.isNull(page)) {
            page = 1;
        }
        if (Objects.isNull(pageSize)) {
            pageSize = 20;
        }
        Page pagez = new Page(page.intValue(), pageSize.intValue());
        pagez = this.bankBindRecordService.selectPage(pagez, new EntityWrapper().eq("mid", (Object)mid));
        List records = pagez.getRecords();
        int total = pagez.getTotal();
        List<BankBindRecoredResult> result = BijectionUtils.invertList(records, BankBindRecoredResult.class);
        PageResult pageResult = new PageResult(Integer.valueOf(total), result);
        return BizResponse.success((Object)pageResult);
    }
}

