package com.fshows.lifecircle.user.service.business.impl.db;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemChildrenService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbUserOemChildrenMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserOemChildren;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * OEM商子账户信息表 服务实现类
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@Service
public class FbUserOemChildrenServiceImpl extends ServiceImpl<FbUserOemChildrenMapper, FbUserOemChildren> implements
    IFbUserOemChildrenService {



    @Autowired
    FbUserOemChildrenMapper mapper;

    @Override
    public List<BaseInfo> getUserIdAndName(Long oemId){


        List<Map<String, Object>> maps = mapper.selectOemIdAndNameByOemId(oemId);

        List<BaseInfo> baseInfos = BijectionUtils.mapsToObjects(maps, BaseInfo.class);
        return baseInfos;
    }

}
