package com.fshows.lifecircle.user.service.business.impl.db;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.IUserConstants;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.app.StaffListParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffListResult;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.dao.FbUserBaseMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantChildrenMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildren;
import com.fshows.lifecircle.user.service.domain.query.StaffDetailQuery;
import com.fshows.lifecircle.user.service.domain.query.StaffListQuery;
import com.xiaoleilu.hutool.util.BeanUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 商户子账户信息表 服务实现类
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@Service
public class FbUserMerchantChildrenServiceImpl extends ServiceImpl<FbUserMerchantChildrenMapper, FbUserMerchantChildren> implements
        IFbUserMerchantChildrenService {

    @Autowired
    FbUserMerchantChildrenMapper userMerchantChildrenMapper;

    @Autowired
    FbUserBaseMapper userBaseMapper;

    @Override
    public PageResult<StaffListResult> getStaffListResult(StaffListParam param) {
        Integer startSize = (param.getPage() - 1) * param.getPageSize();
        Integer endSize = param.getPage() * param.getPageSize();

        Map map = BeanUtil.beanToMap(param);
        map.put("startSize", startSize);
        map.put("endSize", endSize);



        List<StaffListResult> staffListResults = new ArrayList<>();
        List<StaffListQuery> staffListQueries = userMerchantChildrenMapper.getStaffListResult(map);
        Integer total = userMerchantChildrenMapper.getStaffListNum(map);

        if (staffListQueries != null && staffListQueries.size() > 0) {
            for (StaffListQuery staffListQuery : staffListQueries) {
                StaffListResult staffListResult = new StaffListResult();
                BeanUtils.copyProperties(staffListQuery, staffListResult);
                staffListResults.add(staffListResult);
            }
        }

        PageResult<StaffListResult> staffListResultPageResult = new PageResult<>(total, staffListResults);
        return staffListResultPageResult;
    }

    @Override
    public StaffDetailResult getStaffDetailResult(Long uid) {
        StaffDetailResult staffDetailResult = new StaffDetailResult();
        StaffDetailQuery staffDetailQuery = userBaseMapper.getStaffDetaillResult(uid);
        if (staffDetailQuery != null) {
            BeanUtils.copyProperties(staffDetailQuery, staffDetailResult);
        }
        return staffDetailResult;
    }
}
