package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightControlService;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbOemRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserOemMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * OEM商权限配置信息 服务实现类
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@Service
@Slf4j
public class FbOemRightControlServiceImpl extends ServiceImpl<FbOemRightControlMapper, FbOemRightControl> implements
    IFbOemRightControlService {

    @Autowired
    private FbOemRightControlMapper fbOemRightControlMapper;
    @Autowired
    private FbUserOemMapper fbUserOemMapper;

    /**
     * 新增或修改OEM权限
     * @param userId
     * @param array
     * @return
     */
    @Override
    public BizResponse<Boolean> updateOemRightControl(Long userId, String[] array) {
        FbOemRightControl fbOemRightControl;
        log.info("updateOemRightControl execute >> userId={}, array = {}", userId, array);
        try {
            //检查userId 是否合规
            FbUserOem fbUserOem = new FbUserOem();
            fbUserOem.setOemId(userId);
            fbUserOem = fbUserOemMapper.selectOne(fbUserOem);
            if (userId == null || array == null || fbUserOem == null) {
                log.info("2.3.9 - 1, updateOemRightControl check fail, userId or array can not be null");
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            //1、查询是否存在权限
            List<FbOemRightControl> fbOemRightControlList = fbOemRightControlMapper.selectCountByUserId(userId);
            log.info("2.3.9 - 2, updateUserRightControl 存储历史数据 fbAgentRightControlList = {}", JSON.toJSONString(fbOemRightControlList));

            //2、如果存在权限，将旧权限全部删除
            if (fbOemRightControlList.size() > 0) {
                fbOemRightControlMapper.deleteByUserId(userId);
            }

            //3、重新创建新的权限
            Integer i = 0;
            for (String s : array) {
                fbOemRightControl = new FbOemRightControl();
                long businessUniqId = KeyGenerator.getKeyByType(KeyTypeEnum.CONTROL_KEY);
                fbOemRightControl.setId(businessUniqId);
                fbOemRightControl.setOemId(userId);
                fbOemRightControl.setRightKey(s);
                fbOemRightControl.setIsOpen(1);
                fbOemRightControl.setCreateTime(new Date());
                fbOemRightControl.setUpdateTime(new Date());
                Integer addResultCount = fbOemRightControlMapper.insert(fbOemRightControl);
                i = i + addResultCount;
            }

            //4、添加失败删除 回滚数据
            if (i != array.length) {
                fbOemRightControlMapper.deleteByUserId(userId);
                if (fbOemRightControlList != null && fbOemRightControlList.size() > 0) {
                    for (FbOemRightControl control : fbOemRightControlList) {
                        fbOemRightControlMapper.insert(control);
                    }
                }
                return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(),ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }

            return BizResponse.success(Boolean.TRUE);

        } catch (Exception e) {
            log.error("2.3.9 - 3, 方法: updateOemRightControl 发生异常， 参数: userId = {}, array = {},异常: Ex = {}", userId, array,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }
}
