package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindInfoSavaParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindRecordSaveParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantBankBindSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindInfoWithAuthResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindRecoredResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantBankBindDetailLists;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IBankBindService;
import com.fshows.lifecircle.user.service.business.db.IFbBankBindInfoService;
import com.fshows.lifecircle.user.service.business.db.IFbBankBindRecordService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbBankBindInfoMapper;
import com.fshows.lifecircle.user.service.domain.po.FbBankBindInfo;
import com.fshows.lifecircle.user.service.domain.po.FbBankBindRecord;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Service
public class BankBindServiceImpl implements IBankBindService {

    @Autowired
    IFbBankBindRecordService bankBindRecordService;
    @Autowired
    IFbBankBindInfoService bankBindInfoService;

    @Autowired
    FbBankBindInfoMapper bankBindInfoMapper;

    @Override
    public BizResponse<Boolean> saveBankBindRecord(BankBindRecordSaveParam param) {

        FbBankBindRecord record = BijectionUtils.invert(param, FbBankBindRecord.class);

        if (Objects.isNull(record)
                || Objects.isNull(record.getBankId())
                || Objects.isNull(record.getBankName())
                || Objects.isNull(record.getBindStatus())
                || Objects.isNull(record.getCardNo())
                || Objects.isNull(record.getMid())) {


            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        bankBindRecordService.insert(record);


        return BizResponse.success(true);
    }


    @Override
    public BizResponse<Boolean> saveBankBindInfo(BankBindInfoSavaParam param) {


        FbBankBindInfo bankBindInfo = BijectionUtils.invert(param, FbBankBindInfo.class);

        if (Objects.isNull(bankBindInfo)
                || Objects.isNull(bankBindInfo.getBankId())
                || StringUtils.isBlank(bankBindInfo.getBankName())
                || Objects.isNull(bankBindInfo.getMid())
                || StringUtils.isBlank(bankBindInfo.getBankNo())
                || StringUtils.isBlank(bankBindInfo.getAcctId())
                ) {


            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }

        Long bindId = KeyGenerator.getKeyByType(KeyTypeEnum.COMMON_KEY);
        bankBindInfo.setBindId(bindId);
        bankBindInfoService.insert(bankBindInfo);

        return BizResponse.success(true);

    }

    @Override
    public BizResponse<PageResult<MerchantBankBindDetailLists>> merchantBankBindDetailList(MerchantBankBindSearchParam param) {


        Map<String, Object> paramMap = BijectionUtils.bean2Map(param);
        paramMap.put("startNum", (param.getPage() - 1) * param.getPageSize());

        List<Map<String, Object>> retMap = bankBindInfoMapper.merchantBankBindDetailList(paramMap);

        Integer count = bankBindInfoMapper.merchantBankBindDetailListCount(paramMap);

        List<MerchantBankBindDetailLists> ret = BijectionUtils.mapsToObjects(retMap, MerchantBankBindDetailLists.class);


        PageResult<MerchantBankBindDetailLists> result = new PageResult<>(count, ret);
        return BizResponse.success(result);

    }

    @Override
    public BizResponse<BankBindInfoWithAuthResult> getBindInfoByMId(Long mid) {

        Map<String, Object> retMap = bankBindInfoMapper.getAuthAndBindInfoByMId(mid);

        BankBindInfoWithAuthResult result = BijectionUtils.mapToObject(retMap, BankBindInfoWithAuthResult.class);

        return BizResponse.success(result);

    }

    @Override
    public BizResponse<PageResult<BankBindRecoredResult>> getBankBindRecord(Long mid, Integer page, Integer pageSize) {



        if (Objects.isNull(page)){
            page=1;
        }
        if (Objects.isNull(pageSize)){
            pageSize=20;
        }

        Page<FbBankBindRecord> pagez=new Page<>(page,pageSize);
        pagez = bankBindRecordService.selectPage(pagez,new EntityWrapper<FbBankBindRecord>()
                .eq(FbBankBindRecord.MID, mid));

        List<FbBankBindRecord> records = pagez.getRecords();
        int total = pagez.getTotal();

        List<BankBindRecoredResult> result = BijectionUtils.invertList(records, BankBindRecoredResult.class);

        PageResult<BankBindRecoredResult> pageResult = new PageResult<>(total, result);

        return BizResponse.success(pageResult);


    }
}
