/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AgentNodeAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AgentNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AgentNodeDetailsResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AgentNodeResult;
import com.fshows.lifecircle.user.service.business.biz.IAgentNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbAgentNodeService;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.dao.FbAgentNodeMapper;
import com.fshows.lifecircle.user.service.domain.po.FbAgentNode;
import com.fshows.lifecircle.user.service.domain.query.AgentNodeQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-21 20:31
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class AgentNodeServiceImpl implements IAgentNodeService {

  @Autowired
  private IFbAgentNodeService fbAgentNodeService;
  @Autowired
  private FbAgentNodeMapper fbAgentNodeMapper;


  /**
   * 添加或修改 oem 节点对象
   */
  @Override
  public Boolean addAndUpdateOemNode(AgentNodeAddOrUpdateParam param) {

    FbAgentNode node = new FbAgentNode();
    BeanUtils.copyProperties(param, node);

    // 修改
    if (param.getNodeId() != null) {

      node.setNodeId(null);
      return fbAgentNodeService.update(node,
          new EntityWrapper<FbAgentNode>().eq(FbAgentNode.NODE_ID, param.getNodeId()));
      // 添加
    } else {

      node.setNodeId(KeyGenerator.getKeyByType());
      return fbAgentNodeService.insert(node);
    }
  }

  /**
   * oem 节点列表接口
   */
  @Override
  public List<AgentNodeResult> findByPage(AgentNodeQueryParam param) {

    AgentNodeQuery nodeQueryParam = new AgentNodeQuery();
    BeanUtils.copyProperties(param, nodeQueryParam);

    return fbAgentNodeMapper.findAllBySort(nodeQueryParam).stream().map(node -> {

      AgentNodeResult result = new AgentNodeResult();

      BeanUtils.copyProperties(node, result);

      return result;
    }).collect(Collectors.toList());
  }

  /**
   * 获得代理商详情
   */
  @Override
  public AgentNodeDetailsResult getById(Long id) {

    // 获得代理商节点
    FbAgentNode node = fbAgentNodeService.selectOne(
        new EntityWrapper<FbAgentNode>().eq(FbAgentNode.NODE_ID, id).eq(FbAgentNode.IS_DEL, 0));

    if (node != null) {

      AgentNodeDetailsResult nodeDetailsResult = AgentNodeDetailsResult.builder().build();
      BeanUtils.copyProperties(node, nodeDetailsResult);
      Long parentId = node.getParentId();
      nodeDetailsResult.setPid(parentId);

      if (parentId == 0L) {

        nodeDetailsResult.setPidName("根结点");
      } else {

        FbAgentNode pNode = fbAgentNodeService.selectOne(
            new EntityWrapper<FbAgentNode>().eq(FbAgentNode.NODE_ID, parentId)
                .eq(FbAgentNode.IS_DEL, 0));
        nodeDetailsResult.setPidName(pNode != null ? pNode.getNodeName() : "");
      }

      return nodeDetailsResult;
    }
    return null;
  }
}
