/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.ChildrenRoleQuery;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenRoleParam;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;

import java.util.List;

/**
 * 功能：
 * 创建时间：2017-12-15 10:30
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserMerchantChildrenRoleService {


    /**
     *
     * 根据roleId获取角色详情
     *
     * @param roleId
     * @return
     */
    FbUserMerchantChildrenRole getMerchantChildrenRoleByRoleId(Long roleId);


    /**
     * 商户子账号角色添加
     *
     * @param param
     * @return
     */
    BizResponse<Long> addUserMerchantChildrenRole(UserMerchantChildrenRoleParam param);

    /**
     * 商户子账号角色修改
     *
     * @param param
     * @return
     */

    BizResponse<Boolean> updateUserMerchantChildrenRole(UserMerchantChildrenRoleParam param);

    /**
     * 删除角色
     *
     * @param roleId
     * @return
     */

    BizResponse<Boolean> deleteUserMerchantChildrenRole(Long roleId);

    /**
     *
     * 根据mid获取权限列表
     *
     * @param childrenRoleQuery
     * @return
     */
    List<FbUserMerchantChildrenRole> getMerchantChildrenRoleListByCondition(ChildrenRoleQuery childrenRoleQuery);

    /**
     *
     * 根据mid, roleName获取权限列表
     *
     * @param mid
     * @return
     */
    List<FbUserMerchantChildrenRole> getMerchantChildrenRoleList(Long mid, String roleName);
}

