/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemBaseInfoResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemBindCardProtocolResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

public interface IOemService {

    /**
     *  添加user_oem
     * @param param
     * @return
     */
    BizResponse<UserOemDTO> addOem(AddOemParam param);

    BizResponse<Boolean> updateOem(UpdateOemParam param);

    /**
     * 添加oem 配置，参数由应用服务校验，此处不校验
     * @param param
     * @return
     */
    BizResponse addOemConfig(AddOemConfigParma param);

    BizResponse<Boolean> updateOemConfig(UpdateOemConfigParam param);


    BizResponse<PageResult<SearchOemDTO>> searchOem(SearchOemParam param);

    BizResponse<OemResult> getOemByOemId(Long oemID);

    BizResponse<List<OemNodeListDTO>> getNodez();

    BizResponse setOemNodeRight(AddOemNodeRightParam param);

    /**
     * 获取当前oem的全部权限
     * @param oemId
     * @return
     */
    BizResponse<List<OemNodeRightDTO>> getOemNodeRightz(long oemId);

    BizResponse<List<OemRightConfigDTO> > getAllOemRight();


    BizResponse<List<BaseInfo>> getOemListByOemId(Long oemId);

    BizResponse<List<BaseInfo>> getOemList();

    /**
     * 获得绑卡协议
     * @param oemId
     * @return
     */
    OemBindCardProtocolResult getBindProtocol(Long oemId);

    /**
     * 获得所有 oem 列表
     * @return
     */
    List<OemBaseInfoResult> getAllBaseOemList();
}
