/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AppLoginInfoParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AppLoginInfoResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginConfigResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 * @author BuHao
 */
public interface ILoginService {

  /**
   * 登录接口
   * @param loginParam
   * @return
   */
  BizResponse<LoginResult> login(LoginParam loginParam);

  /**
   * 获得登录配置接口（web）
   * @param loginConfigParam
   * @return
   */
  BizResponse<LoginConfigResult> getLoginConf(LoginConfigParam loginConfigParam);

  /**
   * 获得 app 登录信息
   * @return
   */
  AppLoginInfoResult getAppLoginInfo(AppLoginInfoParam param);

  /**
   * app 退出登录
   * @return
   */
  Boolean appLoginOut(String accessToken);
}
