/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeRightDTO;
import com.fshows.lifecircle.service.utils.CollectionUtils;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbOemNodeMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemNode;
import com.fshows.lifecircle.user.service.domain.query.OemNodeQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OemNodeService
implements IOemNodeService {
    @Autowired
    private IFbOemNodeService oemNodeService;
    @Autowired
    private FbOemNodeMapper oemNodeMapper;
    @Autowired
    private IFbUserBaseService userBaseService;

    @Override
    public Boolean addAndUpdateOemNode(OemNodeAddOrUpdateParam param) {
        FbOemNode fbOemNode = new FbOemNode();
        BeanUtils.copyProperties((Object)param, (Object)fbOemNode);
        if (param.getNodeId() != null) {
            fbOemNode.setNodeId(null);
            return this.oemNodeService.update(fbOemNode, new EntityWrapper().eq("node_id", (Object)param.getNodeId()));
        }
        fbOemNode.setNodeId(KeyGenerator.getKeyByType());
        return this.oemNodeService.insert(fbOemNode);
    }

    @Override
    public List<OemNodeResult> findByPage(OemNodeQueryParam param) {
        OemNodeQuery oemNodeQuery = new OemNodeQuery();
        BeanUtils.copyProperties((Object)param, (Object)oemNodeQuery);
        return this.oemNodeMapper.findAllBySort(oemNodeQuery).stream().map(oemNode -> {
            OemNodeResult result = new OemNodeResult();
            BeanUtils.copyProperties((Object)oemNode, (Object)result);
            return result;
        }).collect(Collectors.toList());
    }

    @Override
    public BizResponse<List<OemNodeRightDTO>> findALL() {
        List fbOemNodes = this.oemNodeMapper.selectList(new EntityWrapper().eq("is_del", (Object)0).orderBy("sort", false));
        List<OemNodeRightDTO> oemNodeRightDTOS = BijectionUtils.invertList(fbOemNodes, OemNodeRightDTO.class);
        return BizResponse.success((Object)CollectionUtils.safe(oemNodeRightDTOS));
    }

    @Override
    public OemNodeDetailResult getById(Long id) {
        FbOemNode fbOemNode = (FbOemNode)this.oemNodeService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("node_id", (Object)id));
        if (fbOemNode != null) {
            OemNodeDetailResult result = OemNodeDetailResult.builder().build();
            BeanUtils.copyProperties((Object)fbOemNode, (Object)result);
            if (result.getPid() == 0L) {
                result.setPidName("\u6839\u7ed3\u70b9");
            } else {
                FbOemNode pNode = (FbOemNode)this.oemNodeService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("node_id", (Object)fbOemNode.getPid()));
                result.setPidName(pNode.getTitle());
            }
            return result;
        }
        return null;
    }
}

