/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.NodeParam;
import com.fshows.lifecircle.user.service.business.biz.INodeService;
import com.fshows.lifecircle.user.service.business.db.IFbAgentNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.dao.FbOemNodeRightMapper;
import com.fshows.lifecircle.user.service.dao.FbOemRoleNodeMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemNodeRight;
import com.fshows.lifecircle.user.service.domain.po.FbOemRoleNode;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import com.fshows.lifecircle.user.service.domain.po.FbUserOemChildren;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeServiceImpl
implements INodeService {
    @Autowired
    private FbOemNodeRightMapper fbOemNodeRightMapper;
    @Autowired
    private IFbOemNodeService fbOemNodeService;
    @Autowired
    private FbOemRoleNodeMapper fbOemRoleNodeMapper;
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserOemChildrenService fbUserOemChildrenService;
    @Autowired
    private IFbAgentNodeService agentNodeService;

    @Override
    public List<NodeParam> getNodeTreeByUserId(Long userId) {
        FbUserBase userBase = (FbUserBase)this.fbUserBaseService.selectOne(new EntityWrapper().eq("base_id", (Object)userId));
        if (userBase == null) {
            FbUserOem fbUserOem = (FbUserOem)this.fbUserOemService.selectOne(new EntityWrapper().eq("oem_id", (Object)userId));
            if (fbUserOem == null) {
                return null;
            }
            userId = fbUserOem.getBaseId();
            userBase = (FbUserBase)this.fbUserBaseService.selectOne(new EntityWrapper().eq("base_id", (Object)userId));
        }
        Integer userType = userBase.getUserType();
        Integer isChild = userBase.getIsChild();
        if (userType == 1 && isChild == 0) {
            FbUserOem fbUserOem = (FbUserOem)this.fbUserOemService.selectOne(new EntityWrapper().eq("base_id", (Object)userId));
            return this.getNodeTreeByOemIdOrRoleId(fbUserOem.getOemId(), null);
        }
        if (userType == 1 && isChild == 1) {
            FbUserOemChildren fbUserOemChildren = (FbUserOemChildren)this.fbUserOemChildrenService.selectOne(new EntityWrapper().eq("base_id", (Object)userId));
            return this.getNodeTreeByOemIdOrRoleId(null, fbUserOemChildren.getRoleId());
        }
        if (userType.equals(UserType.AGENT.getValue())) {
            return this.getNodeTreeByAgentId(null);
        }
        if (userType.equals(UserType.GRANT.getValue())) {
            return this.getNodeTreeByAgentId(null);
        }
        return null;
    }

    @Override
    public List<NodeParam> getNodeTreeByAgentId(Long agentId) {
        List agentNodeList = this.agentNodeService.selectList(new EntityWrapper().eq("is_del", (Object)0).eq("status", (Object)1));
        List nodeList = agentNodeList.stream().map(fbAgentNode -> new NodeParam().setId(fbAgentNode.getNodeId()).setName(fbAgentNode.getNodeName()).setPid(fbAgentNode.getParentId()).setPath(fbAgentNode.getAction()).setCheck(Boolean.valueOf(true))).collect(Collectors.toList());
        Map<Long, List<NodeParam>> gropuByPidList = nodeList.stream().collect(Collectors.groupingBy(NodeParam::getPid));
        for (NodeParam nodeParam2 : nodeList) {
            List<NodeParam> childrenList = gropuByPidList.get(nodeParam2.getId());
            nodeParam2.setChildren(childrenList);
        }
        return nodeList.stream().filter(nodeParam -> nodeParam.getPid() == 0L).collect(Collectors.toList());
    }

    @Override
    public Boolean addAndUpdateRoleNode(List<Long> nodeIds, Long roleId) {
        List delList;
        List dbNodeList = this.fbOemRoleNodeMapper.findNodeId(roleId);
        List addList = nodeIds.stream().filter(node -> !dbNodeList.contains(node)).collect(Collectors.toList());
        if (addList != null) {
            for (Long aLong : addList) {
                this.fbOemRoleNodeMapper.insert((Object)new FbOemRoleNode().setNodeId(aLong).setRoleId(roleId));
            }
        }
        if ((delList = dbNodeList.stream().filter(node -> !nodeIds.contains(node)).collect(Collectors.toList())) != null) {
            for (Long aLong : delList) {
                this.fbOemRoleNodeMapper.update((Object)new FbOemRoleNode().setIsDel(Integer.valueOf(1)), new EntityWrapper().eq("role_id", (Object)roleId).eq("node_id", (Object)aLong).eq("is_del", (Object)0));
            }
        }
        return true;
    }

    @Override
    public Boolean addAndUpdateOemRoleNode(List<Long> nodeIds, Long oemId) {
        List delList;
        List dbNodeList = this.fbOemNodeRightMapper.findNodeId(oemId);
        List addList = nodeIds.stream().filter(node -> !dbNodeList.contains(node)).collect(Collectors.toList());
        if (addList != null) {
            for (Long aLong : addList) {
                this.fbOemNodeRightMapper.insert((Object)new FbOemNodeRight().setNodeId(aLong).setOemId(oemId));
            }
        }
        if ((delList = dbNodeList.stream().filter(node -> !nodeIds.contains(node)).collect(Collectors.toList())) != null) {
            for (Long aLong : delList) {
                this.fbOemNodeRightMapper.update((Object)new FbOemNodeRight().setIsDel(Integer.valueOf(1)), new EntityWrapper().eq("oem_id", (Object)oemId).eq("node_id", (Object)aLong).eq("is_del", (Object)0));
            }
        }
        return true;
    }

    @Override
    public List<NodeParam> getNodeTreeByOemIdOrRoleId(Long oemId, Long roleId) {
        List hasNodeIds = null;
        hasNodeIds = oemId != null ? this.fbOemNodeRightMapper.findNodeId(oemId) : this.fbOemRoleNodeMapper.findNodeId(roleId);
        return this.getNodeTree(hasNodeIds);
    }

    @Override
    public List<NodeParam> getNodeTree(List<Long> hasNodeIds) {
        List oemList = this.fbOemNodeService.selectList(new EntityWrapper().eq("is_del", (Object)0));
        List nodeList = oemList.stream().map(fbOemNode -> new NodeParam().setId(fbOemNode.getNodeId()).setName(fbOemNode.getTitle()).setPid(fbOemNode.getPid()).setPath(fbOemNode.getAction()).setCheck(Boolean.valueOf(hasNodeIds.contains(fbOemNode.getNodeId())))).collect(Collectors.toList());
        Map<Long, List<NodeParam>> gropuByPidList = nodeList.stream().collect(Collectors.groupingBy(NodeParam::getPid));
        for (NodeParam nodeParam2 : nodeList) {
            List<NodeParam> childrenList = gropuByPidList.get(nodeParam2.getId());
            nodeParam2.setChildren(childrenList);
        }
        return nodeList.stream().filter(nodeParam -> nodeParam.getPid() == 0L).collect(Collectors.toList());
    }
}

