/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AppLoginInfoParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AppLoginInfoResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginConfigResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.ILoginService;
import com.fshows.lifecircle.user.service.business.db.IFbAppLoginLogService;
import com.fshows.lifecircle.user.service.business.db.IFbOemConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserLoginLogService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.LoginPlatformTypeEnum;
import com.fshows.lifecircle.user.service.business.utils.UserTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbUserBaseMapper;
import com.fshows.lifecircle.user.service.domain.po.FbAppLoginLog;
import com.fshows.lifecircle.user.service.domain.po.FbOemConfig;
import com.fshows.lifecircle.user.service.domain.po.FbUserAgent;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserLoginLog;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchant;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildren;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import com.fshows.lifecircle.user.service.domain.po.FbUserOemChildren;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.util.NetUtil;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements ILoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbOemConfigService fbOemConfigService;
    @Autowired
    private IFbUserOemChildrenService fbUserOemChildrenService;
    @Autowired
    private IFbUserLoginLogService fbUserLoginLogService;
    @Autowired
    private IFbAppLoginLogService fbAppLoginLogService;
    @Autowired
    private IFbUserMerchantChildrenService fbUserMerchantChildrenService;
    @Autowired
    private IFbUserMerchantChildrenRoleService fbUserMerchantChildrenRoleService;
    @Autowired
    private IFbOemRoleService fbOemRoleService;
    @Autowired
    private FbUserBaseMapper fbUserBaseMapper;

    @Override
    public BizResponse<LoginResult> login(LoginParam loginParam) {
        FbUserBase userBase = (FbUserBase)this.fbUserBaseService.selectOne(new EntityWrapper().eq("username", (Object)loginParam.getUsername()).eq("is_del", (Object)0));
        LoginResult loginResult = null;
        BizResponse<LoginResult> response = this.checkLogin(loginParam, userBase);
        if (!response.isSuccess().booleanValue()) {
            return response;
        }
        loginResult = (LoginResult)response.getData();
        String requestPwdByMd5 = SecureUtil.md5((String)(loginParam.getPassword() + userBase.getSalt()));
        if (!requestPwdByMd5.equals(userBase.getUserpwd())) {
            this.loginErrorController(userBase);
            return BizResponse.fail((String)ErrorCodeEnum.PASSWORD_ERROR.getCode(), (String)ErrorCodeEnum.PASSWORD_ERROR.getMsg());
        }
        this.fbUserBaseService.update(new FbUserBase().setLoginLockTime(Long.valueOf(0L)).setLoginErrorCount(Integer.valueOf(0)), new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
        if (loginParam.getIsApp().booleanValue()) {
            String accessToken = SecureUtil.md5((String)(loginResult.getOemId() + "" + loginResult.getUserId() + "" + System.currentTimeMillis()));
            loginResult.setAccessToken(accessToken);
        }
        this.saveLoginLog(loginParam, loginResult, this.getLoginPlatformType(userBase.getUserType()));
        return BizResponse.success((Object)loginResult);
    }

    private void loginErrorController(FbUserBase userBase) {
        Integer loginErrorCount = userBase.getLoginErrorCount();
        loginErrorCount = loginErrorCount + 1;
        Integer maxLoginCount = 3;
        Long lockTimeMinutes = 120L;
        long loginLockTime = 0L;
        if (loginErrorCount >= maxLoginCount) {
            loginLockTime = System.currentTimeMillis() + lockTimeMinutes * 60L * 1000L;
        }
        this.fbUserBaseService.update(new FbUserBase().setLoginErrorCount(loginErrorCount).setLoginLockTime(Long.valueOf(loginLockTime)), new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
    }

    private void saveLoginLog(LoginParam loginParam, LoginResult loginResult, LoginPlatformTypeEnum loginPlatformTypeEnum) {
        try {
            long lastLoginIp = NetUtil.ipv4ToLong((String)loginParam.getLoginIp());
            this.fbUserBaseService.update(new FbUserBase().setLastLoginIp(Long.valueOf(lastLoginIp)).setLastLoginTime(new Date()), new EntityWrapper().eq("username", (Object)loginParam.getUsername()));
            Long userId = loginResult.getUserId();
            this.fbUserLoginLogService.insert(new FbUserLoginLog().setLoginIp(Long.valueOf(lastLoginIp)).setUserId(userId).setPlatformType(loginPlatformTypeEnum.getVal()));
            if (LoginPlatformTypeEnum.APP.equals((Object)loginPlatformTypeEnum)) {
                FbAppLoginLog appLoginLog = (FbAppLoginLog)this.fbAppLoginLogService.selectOne(new EntityWrapper().eq("user_id", (Object)userId));
                if (appLoginLog == null) {
                    this.fbAppLoginLogService.insert(new FbAppLoginLog().setAccessToken(loginResult.getAccessToken()).setUserId(userId));
                } else {
                    loginResult.setLastAccessToken(appLoginLog.getAccessToken());
                    this.fbAppLoginLogService.update(new FbAppLoginLog().setAccessToken(loginResult.getAccessToken()), new EntityWrapper().eq("user_id", (Object)userId));
                }
            }
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: login \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: loginParam = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)loginParam), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public BizResponse<LoginConfigResult> getLoginConf(LoginConfigParam loginConfigParam) {
        Integer configType = loginConfigParam.getConfigType();
        String oemShortName = loginConfigParam.getOemShortName();
        FbOemConfig oemConfig = (FbOemConfig)this.fbOemConfigService.selectOne(new EntityWrapper().eq("sub_domain", (Object)oemShortName));
        if (oemConfig == null) {
            return BizResponse.fail((String)ErrorCodeEnum.NO_HAVE_LOGIN_CONFIG.getCode(), (String)ErrorCodeEnum.NO_HAVE_LOGIN_CONFIG.getMsg());
        }
        LoginConfigResult loginConfigResult = new LoginConfigResult();
        loginConfigResult.setLogoutUrl(oemConfig.getSubDomain());
        loginConfigResult.setOemId(oemConfig.getOemId());
        loginConfigResult.setWebLogo(oemConfig.getWebLogo());
        if (configType.equals(UserTypeEnum.OEM.getValue())) {
            loginConfigResult.setLoginBg(oemConfig.getAdminLoginBg());
            loginConfigResult.setLoginLogo(oemConfig.getAdminLoginLogo());
            loginConfigResult.setTitle(oemConfig.getAdminLoginTitle());
            loginConfigResult.setLogo(oemConfig.getAdminLogo());
        } else if (configType.equals(UserTypeEnum.AGENT.getValue()) || configType.equals(UserTypeEnum.GRANT.getValue())) {
            loginConfigResult.setLoginBg(oemConfig.getAgentLoginBg());
            loginConfigResult.setLoginLogo(oemConfig.getAgentLoginLogo());
            loginConfigResult.setLogo(oemConfig.getAgentLogo());
            loginConfigResult.setTitle(oemConfig.getAgentLoginTitle());
        } else if (configType.equals(UserTypeEnum.MERCHANT.getValue())) {
            loginConfigResult.setLoginBg(oemConfig.getUserLoginBg());
            loginConfigResult.setLoginLogo(oemConfig.getUserLoginLogo());
            loginConfigResult.setLogo(oemConfig.getUserLogo());
            loginConfigResult.setTitle(oemConfig.getUserLoginTitle());
        }
        return BizResponse.success((Object)loginConfigResult);
    }

    @Override
    public AppLoginInfoResult getAppLoginInfo(AppLoginInfoParam param) {
        FbUserBase fbUserBase;
        String accessToken = param.getAccessToken();
        FbAppLoginLog appLoginLog = (FbAppLoginLog)this.fbAppLoginLogService.selectOne(new EntityWrapper().eq("access_token", (Object)accessToken));
        if (appLoginLog != null && (fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(new EntityWrapper().eq("base_id", (Object)appLoginLog.getUserId()).eq("is_del", (Object)0))) != null) {
            AppLoginInfoResult result = new AppLoginInfoResult();
            result.setAccessToken(param.getAccessToken());
            result.setUsername(fbUserBase.getUsername());
            result.setUserId(fbUserBase.getBaseId());
            Integer isChild = fbUserBase.getIsChild();
            Long userId = fbUserBase.getBaseId();
            if (1 == isChild) {
                FbUserMerchantChildren merchantChildren = (FbUserMerchantChildren)this.fbUserMerchantChildrenService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("base_id", (Object)userId));
                if (merchantChildren != null) {
                    result.setIsPush(Integer.valueOf(1));
                    result.setStoreName("todo");
                    result.setMid(merchantChildren.getMid());
                    result.setStoreId(merchantChildren.getStoreId());
                    Long roleId = merchantChildren.getRoleId();
                    FbUserMerchantChildrenRole merchantChildrenRole = (FbUserMerchantChildrenRole)this.fbUserMerchantChildrenRoleService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("role_id", (Object)roleId));
                    result.setRoleType(merchantChildrenRole.getRoleType());
                    FbUserMerchant userMerchant = (FbUserMerchant)this.fbUserMerchantService.selectOne(new EntityWrapper().eq("mid", (Object)merchantChildren.getMid()));
                    if (userMerchant != null) {
                        Long vipTime = userMerchant.getVipTime();
                        if (System.currentTimeMillis() >= vipTime || userMerchant.getStatus() != 1) {
                            return null;
                        }
                        result.setOemId(userMerchant.getOemId());
                        result.setAgentId(userMerchant.getAgentId());
                        FbUserBase parentUser = (FbUserBase)this.fbUserBaseService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("base_id", (Object)userMerchant.getBaseId()));
                        if (parentUser != null) {
                            result.setMUsername(parentUser.getUsername());
                        } else {
                            result.setMUsername("");
                        }
                    }
                    return result;
                }
            } else {
                FbUserMerchant userMerchant = (FbUserMerchant)this.fbUserMerchantService.selectOne(new EntityWrapper().eq("base_id", (Object)userId));
                if (userMerchant != null) {
                    Long vipTime = userMerchant.getVipTime();
                    if (System.currentTimeMillis() >= vipTime || userMerchant.getStatus() != 1) {
                        return null;
                    }
                    result.setIsPush(Integer.valueOf(1));
                    result.setStoreName("todo");
                    result.setMid(userMerchant.getMid());
                    result.setStoreId(Long.valueOf(0L));
                    result.setRoleType(Integer.valueOf(0));
                    result.setOemId(userMerchant.getOemId());
                    result.setAgentId(userMerchant.getAgentId());
                    result.setMUsername(fbUserBase.getUsername());
                    return result;
                }
            }
        }
        return null;
    }

    @Override
    public Boolean appLoginOut(String accessToken) {
        return this.fbAppLoginLogService.update(new FbAppLoginLog().setAccessToken(""), new EntityWrapper().eq("access_token", (Object)accessToken));
    }

    private BizResponse<LoginResult> checkLogin(LoginParam loginParam, FbUserBase userBase) {
        if (userBase == null) {
            return BizResponse.fail((String)ErrorCodeEnum.USERNAME_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USERNAME_NOT_EXIST.getMsg());
        }
        if (userBase.getStatus() != 1) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_DISABLE.getCode(), (String)ErrorCodeEnum.USER_DISABLE.getMsg());
        }
        boolean isChild = userBase.getIsChild() == 1;
        Integer userType = loginParam.getUserType();
        if (userBase.getLoginLockTime() != 0L) {
            if (userBase.getLoginLockTime() > System.currentTimeMillis()) {
                ErrorCodeEnum loginLock = ErrorCodeEnum.LOGIN_LOCK;
                return BizResponse.fail((String)loginLock.getCode(), (String)loginLock.getMsg());
            }
            this.fbUserBaseService.update(new FbUserBase().setLoginErrorCount(Integer.valueOf(0)).setLoginLockTime(Long.valueOf(0L)), new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
        }
        if (userType != null && !userBase.getUserType().equals(userType) && userBase.getUserType().intValue() != UserType.GRANT.getValue().intValue()) {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        UserTypeEnum userTypeEnum = UserTypeEnum.valueOf(userType);
        return this.checkByUserType(userTypeEnum, userBase, isChild, loginParam);
    }

    private BizResponse<LoginResult> checkOem(FbUserBase userBase, Boolean isChild, LoginParam param) {
        LoginResult loginResult = new LoginResult();
        FbUserOem userOem = null;
        if (isChild.booleanValue()) {
            FbUserOemChildren fbUserOemChildren = (FbUserOemChildren)this.fbUserOemChildrenService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
            if (fbUserOemChildren == null) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
            Long belognOemId = fbUserOemChildren.getOemId();
            userOem = (FbUserOem)this.fbUserOemService.selectOne(new EntityWrapper().eq("oem_id", (Object)belognOemId));
            Long roleId = fbUserOemChildren.getRoleId();
            int count = this.fbOemRoleService.selectCount(new EntityWrapper().eq("is_del", (Object)0).eq("status", (Object)1).eq("role_id", (Object)roleId));
            if (count == 0) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
        } else {
            userOem = (FbUserOem)this.fbUserOemService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
        }
        if (userOem == null) {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        Long oemId = userOem.getOemId();
        if (!oemId.equals(param.getOemId())) {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        loginResult.setSelf(Boolean.valueOf(userOem.getIsSelfSupport() == 1));
        loginResult.setOemId(userOem.getOemId());
        return BizResponse.success((Object)loginResult);
    }

    private BizResponse<LoginResult> checkByAgent(FbUserBase userBase) {
        LoginResult loginResult = new LoginResult();
        FbUserAgent userAgent = (FbUserAgent)this.fbUserAgentService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
        if (userAgent == null) {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        if (System.currentTimeMillis() >= userAgent.getVipTime()) {
            ErrorCodeEnum userOverdue = ErrorCodeEnum.USER_OVERDUE;
            return BizResponse.fail((String)userOverdue.getCode(), (String)userOverdue.getMsg());
        }
        if (userBase.getUserType().intValue() == UserType.AGENT.getValue().intValue()) {
            loginResult.setUserType(userBase.getUserType());
            loginResult.setAgentId(userAgent.getAgentId());
        } else {
            loginResult.setUserType(userBase.getUserType());
            loginResult.setGrantId(userAgent.getAgentId());
            loginResult.setAgentId(userAgent.getBelong());
        }
        return BizResponse.success((Object)loginResult);
    }

    private BizResponse<LoginResult> checkByMerchant(FbUserBase userBase, Boolean isChild) {
        LoginResult loginResult = new LoginResult();
        FbUserMerchant userMerchant = null;
        if (isChild.booleanValue()) {
            FbUserMerchantChildren merchantChildren = (FbUserMerchantChildren)this.fbUserMerchantChildrenService.selectOne(new EntityWrapper().eq("is_del", (Object)0).eq("base_id", (Object)userBase.getBaseId()));
            if (merchantChildren != null) {
                Long mid = merchantChildren.getMid();
                userMerchant = (FbUserMerchant)this.fbUserMerchantService.selectOne(new EntityWrapper().eq("mid", (Object)mid));
            }
        } else {
            userMerchant = (FbUserMerchant)this.fbUserMerchantService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
        }
        if (userMerchant == null) {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        Long vipTime = userMerchant.getVipTime();
        if (System.currentTimeMillis() >= vipTime) {
            ErrorCodeEnum userOverdue = ErrorCodeEnum.USER_OVERDUE;
            return BizResponse.fail((String)userOverdue.getCode(), (String)userOverdue.getMsg());
        }
        loginResult.setOemId(userMerchant.getOemId());
        Long agentId = userMerchant.getAgentId();
        FbUserAgent userAgent = (FbUserAgent)this.fbUserAgentService.selectOne(new EntityWrapper().eq("base_id", (Object)agentId));
        if (userAgent == null) {
            loginResult.setAgentId(Long.valueOf(0L));
            loginResult.setGrantId(Long.valueOf(0L));
        } else {
            Long belong = userAgent.getBelong();
            if (belong != 0L) {
                loginResult.setAgentId(belong);
                loginResult.setGrantId(agentId);
            } else {
                loginResult.setAgentId(agentId);
            }
        }
        return BizResponse.success((Object)loginResult);
    }

    private LoginPlatformTypeEnum getLoginPlatformType(Integer userType) {
        UserTypeEnum userTypeEnum = UserTypeEnum.valueOf(userType);
        switch (userTypeEnum) {
            case OEM: {
                return LoginPlatformTypeEnum.OEM_SYSTEM;
            }
            case AGENT: {
                return LoginPlatformTypeEnum.AGENT_SYSTEM;
            }
            case GRANT: {
                return LoginPlatformTypeEnum.AGENT_SYSTEM;
            }
            case MERCHANT: {
                return LoginPlatformTypeEnum.APP;
            }
        }
        return LoginPlatformTypeEnum.APP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BizResponse checkByUserType(UserTypeEnum userTypeEnum, FbUserBase userBase, Boolean isChild, LoginParam loginParam) {
        LoginResult loginResult = null;
        if (UserTypeEnum.OEM.equals((Object)userTypeEnum)) {
            BizResponse<LoginResult> response = this.checkOem(userBase, isChild, loginParam);
            if (!response.isSuccess().booleanValue()) return response;
            loginResult = (LoginResult)response.getData();
        } else if (UserTypeEnum.AGENT.equals((Object)userTypeEnum)) {
            BizResponse<LoginResult> response = this.checkByAgent(userBase);
            if (!response.isSuccess().booleanValue()) return response;
            loginResult = (LoginResult)response.getData();
        } else {
            if (!UserTypeEnum.MERCHANT.equals((Object)userTypeEnum)) return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            BizResponse<LoginResult> response = this.checkByMerchant(userBase, isChild);
            if (!response.isSuccess().booleanValue()) return response;
            loginResult = (LoginResult)response.getData();
        }
        loginResult.setUserId(userBase.getBaseId());
        if (loginParam.getOemId() != null) {
            loginResult.setOemId(loginParam.getOemId());
        }
        loginResult.setChild(isChild);
        loginResult.setUserType(userBase.getUserType());
        loginResult.setUsername(userBase.getUsername());
        return BizResponse.success((Object)loginResult);
    }
}

