/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AgentNodeAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AgentNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AgentNodeDetailsResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AgentNodeResult;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.business.biz.IAgentNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbAgentNodeService;
import com.fshows.lifecircle.user.service.dao.FbAgentNodeMapper;
import com.fshows.lifecircle.user.service.domain.po.FbAgentNode;
import com.fshows.lifecircle.user.service.domain.query.AgentNodeQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentNodeServiceImpl
implements IAgentNodeService {
    @Autowired
    private IFbAgentNodeService fbAgentNodeService;
    @Autowired
    private FbAgentNodeMapper fbAgentNodeMapper;

    @Override
    public Boolean addAndUpdateOemNode(AgentNodeAddOrUpdateParam param) {
        FbAgentNode node = new FbAgentNode();
        BeanUtils.copyProperties((Object)param, (Object)node);
        if (param.getNodeId() != null) {
            node.setNodeId(null);
            return this.fbAgentNodeService.update(node, new EntityWrapper().eq("node_id", (Object)param.getNodeId()));
        }
        node.setNodeId(KeyGenerator.getKeyByType());
        return this.fbAgentNodeService.insert(node);
    }

    @Override
    public List<AgentNodeResult> findByPage(AgentNodeQueryParam param) {
        AgentNodeQuery nodeQueryParam = new AgentNodeQuery();
        BeanUtils.copyProperties((Object)param, (Object)nodeQueryParam);
        return this.fbAgentNodeMapper.findAllBySort(nodeQueryParam).stream().map(node -> {
            AgentNodeResult result = new AgentNodeResult();
            BeanUtils.copyProperties((Object)node, (Object)result);
            return result;
        }).collect(Collectors.toList());
    }

    @Override
    public AgentNodeDetailsResult getById(Long id) {
        FbAgentNode node = (FbAgentNode)this.fbAgentNodeService.selectOne(new EntityWrapper().eq("node_id", (Object)id).eq("is_del", (Object)0));
        if (node != null) {
            AgentNodeDetailsResult nodeDetailsResult = AgentNodeDetailsResult.builder().build();
            BeanUtils.copyProperties((Object)node, (Object)nodeDetailsResult);
            Long parentId = node.getParentId();
            nodeDetailsResult.setPid(parentId);
            if (parentId == 0L) {
                nodeDetailsResult.setPidName("\u6839\u7ed3\u70b9");
            } else {
                FbAgentNode pNode = (FbAgentNode)this.fbAgentNodeService.selectOne(new EntityWrapper().eq("node_id", (Object)parentId).eq("is_del", (Object)0));
                nodeDetailsResult.setPidName(pNode != null ? pNode.getNodeName() : "");
            }
            return nodeDetailsResult;
        }
        return null;
    }
}

