package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantChildrenRoleRightControlService;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbMerchantChildrenRoleRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbMerchantRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantChildrenRoleMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 商户子账户角色权限配置信息 服务实现类
 * </p>
 *
 * @author BuHao
 * @since 2018-01-03
 */
@Service
@Slf4j
public class FbMerchantChildrenRoleRightControlServiceImpl extends ServiceImpl<FbMerchantChildrenRoleRightControlMapper, FbMerchantChildrenRoleRightControl> implements
        IFbMerchantChildrenRoleRightControlService {

    @Autowired
    private FbMerchantChildrenRoleRightControlMapper fbMerchantChildrenRoleRightControlMapper;

    @Autowired
    private FbUserMerchantChildrenRoleMapper fbUserMerchantChildrenRoleMapper;

    @Override
    public BizResponse<Boolean> updateMerchantChildrenRoleRightControl(Long roleId, String[] array) {
        FbMerchantRightControl fbMerchantRightControl;
        log.info("updateMerchantChildrenRoleRightControl execute >> roleId={}, array = {}", roleId, array);
        try {
            //检查userId 是否合规
            FbUserMerchantChildrenRole fbUserMerchantChildrenRole = new FbUserMerchantChildrenRole();
            fbUserMerchantChildrenRole.setRoleId(roleId);
            fbUserMerchantChildrenRole = fbUserMerchantChildrenRoleMapper.selectOne(fbUserMerchantChildrenRole);
            if (roleId == null || array == null || fbUserMerchantChildrenRole == null) {
                log.info("2.3.9 - 1, updateOemRightControl check fail, userId or array can not be null");
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            //1、查询是否存在权限
            List<FbMerchantChildrenRoleRightControl> controlList = fbMerchantChildrenRoleRightControlMapper.selectCountByRoleId(roleId);
            log.info("2.3.9 - 2, updateMerchantRightControl 存储历史数据 fbAgentRightControlList = {}", JSON.toJSONString(controlList));

            //2、如果存在权限，将旧权限全部删除
            if (controlList.size() > 0) {
                fbMerchantChildrenRoleRightControlMapper.deleteByRoleId(roleId);
            }

            //3、重新创建新的权限
            Integer i = 0;
            for (String s : array) {
                FbMerchantChildrenRoleRightControl obj = new FbMerchantChildrenRoleRightControl();
                long businessUniqId = KeyGenerator.getKeyByType(KeyTypeEnum.CONTROL_KEY);
                obj.setId(businessUniqId);
                obj.setRoleId(roleId);
                obj.setRightKey(s);
                obj.setIsOpen(1);
                Integer addResultCount = fbMerchantChildrenRoleRightControlMapper.insert(obj);
                i = i + addResultCount;
            }

            //4、添加失败删除 回滚数据
            if (i != array.length) {
                fbMerchantChildrenRoleRightControlMapper.deleteByRoleId(roleId);
                if (controlList != null && controlList.size() > 0) {
                    for (FbMerchantChildrenRoleRightControl control : controlList) {
                        fbMerchantChildrenRoleRightControlMapper.insert(control);
                    }
                }
                return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }

            return BizResponse.success(Boolean.TRUE);

        } catch (Exception e) {
            log.error("2.3.9 - 3, 方法: updateMerchantRightControl 发生异常， 参数: userId = {}, array = {},异常: Ex = {}", roleId, array,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }
}
