package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindInfoSavaParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindRecordSaveParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantBankBindSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindInfoWithAuthResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindRecoredResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantBankBindDetailLists;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;


public interface IBankBindService {
    BizResponse<Boolean> saveBankBindRecord(BankBindRecordSaveParam param);

    BizResponse<Boolean> saveBankBindInfo(BankBindInfoSavaParam param);

    BizResponse<PageResult<MerchantBankBindDetailLists>> merchantBankBindDetailList(MerchantBankBindSearchParam param);

    BizResponse<BankBindInfoWithAuthResult> getBindInfoByMId(Long mid);

    BizResponse<List<BankBindRecoredResult> > getBankBindRecord(Long mid);
}
