/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.db.IFbAgentRightControlService;
import com.fshows.lifecircle.user.service.dao.FbAgentRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserAgentMapper;
import com.fshows.lifecircle.user.service.domain.po.FbAgentRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserAgent;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FbAgentRightControlServiceImpl
extends ServiceImpl<FbAgentRightControlMapper, FbAgentRightControl>
implements IFbAgentRightControlService {
    private static final Logger log = LoggerFactory.getLogger(FbAgentRightControlServiceImpl.class);
    @Autowired
    private FbAgentRightControlMapper fbAgentRightControlMapper;
    @Autowired
    private FbUserAgentMapper fbUserAgentMapper;

    @Override
    public BizResponse<Boolean> updateAgentRightControl(Long userId, String[] array) {
        log.info("updateAgentRightControl execute >> userId={}, array = {}", (Object)userId, (Object)array);
        try {
            FbUserAgent fbUserAgent = new FbUserAgent();
            fbUserAgent.setAgentId(userId);
            fbUserAgent = (FbUserAgent)this.fbUserAgentMapper.selectOne((Object)fbUserAgent);
            if (userId == null || array == null || fbUserAgent == null) {
                log.info("2.3.9 - 1, updateUserRightControl check fail, userId or array can not be null");
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            List fbAgentRightControlList = this.fbAgentRightControlMapper.selectCountByUserId(userId);
            log.info("2.3.9 - 2, updateUserRightControl \u5b58\u50a8\u5386\u53f2\u6570\u636e fbAgentRightControlList = {}", (Object)JSON.toJSONString((Object)fbAgentRightControlList));
            if (fbAgentRightControlList.size() > 0) {
                this.fbAgentRightControlMapper.deleteByUserId(userId);
            }
            Integer i = 0;
            for (String s : array) {
                FbAgentRightControl fbAgentRightControl = new FbAgentRightControl();
                long businessUniqId = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.CONTROL_KEY);
                fbAgentRightControl.setId(Long.valueOf(businessUniqId));
                fbAgentRightControl.setAgentId(userId);
                fbAgentRightControl.setRightKey(s);
                fbAgentRightControl.setIsOpen(Integer.valueOf(1));
                fbAgentRightControl.setCreateTime(new Date());
                fbAgentRightControl.setUpdateTime(new Date());
                Integer addResultCount = this.fbAgentRightControlMapper.insert((Object)fbAgentRightControl);
                i = i + addResultCount;
            }
            if (i != array.length) {
                this.fbAgentRightControlMapper.deleteByUserId(userId);
                if (fbAgentRightControlList != null && fbAgentRightControlList.size() > 0) {
                    for (FbAgentRightControl control : fbAgentRightControlList) {
                        this.fbAgentRightControlMapper.insert((Object)control);
                    }
                }
                return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }
            return BizResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("2.3.9 - 3, \u65b9\u6cd5: updateUserRightControl \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: userId = {}, array = {},\u5f02\u5e38: Ex = {}", new Object[]{userId, array, ExceptionUtils.getStackTrace((Throwable)e)});
            return BizResponse.serverError();
        }
    }
}

