/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.ChildrenRoleQuery;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenRoleParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserMerchantChildrenRoleServiceImpl
implements IUserMerchantChildrenRoleService {
    private static final Logger log = LoggerFactory.getLogger(UserMerchantChildrenRoleServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbUserMerchantChildrenService fbUserMerchantChildrenService;
    @Autowired
    private IFbUserMerchantChildrenRoleService fbUserMerchantChildrenRoleService;
    @Autowired
    private IUserBaseService userBaseService;
    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    @Override
    public List<FbUserMerchantChildrenRole> getMerchantChildrenRoleListByCondition(ChildrenRoleQuery childrenRoleQuery) {
        List list = this.fbUserMerchantChildrenRoleService.selectList(Condition.create().eq("mid", (Object)childrenRoleQuery.getMid()).eq("is_del", (Object)0).eq("status", (Object)1).eq(childrenRoleQuery.getRoleType() != null, "role_type", (Object)childrenRoleQuery.getRoleType()).like(childrenRoleQuery.getRoleName() != null, "name", childrenRoleQuery.getRoleName()));
        return list;
    }

    @Override
    public List<FbUserMerchantChildrenRole> getMerchantChildrenRoleList(Long mid, String roleName) {
        List list = this.fbUserMerchantChildrenRoleService.selectList(Condition.create().eq("mid", (Object)mid).eq("is_del", (Object)0).eq("status", (Object)1).like(roleName != null, "name", roleName));
        return list;
    }

    @Override
    public FbUserMerchantChildrenRole getMerchantChildrenRoleByRoleId(Long roleId) {
        FbUserMerchantChildrenRole obj = (FbUserMerchantChildrenRole)this.fbUserMerchantChildrenRoleService.selectOne(Condition.create().eq("role_id", (Object)roleId));
        return obj;
    }

    @Override
    public BizResponse<Long> addUserMerchantChildrenRole(UserMerchantChildrenRoleParam param) {
        FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
        BeanUtils.copyProperties((Object)param, (Object)obj);
        long businessUniqId = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.MERCHANT_CHILDD_ROLE_KEY);
        obj.setRoleId(Long.valueOf(businessUniqId));
        boolean addResult = this.fbUserMerchantChildrenRoleService.insert(obj);
        if (addResult) {
            return BizResponse.success((Object)businessUniqId);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse<Boolean> updateUserMerchantChildrenRole(UserMerchantChildrenRoleParam param) {
        FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
        BeanUtils.copyProperties((Object)param, (Object)obj);
        boolean result = this.fbUserMerchantChildrenRoleService.update(obj, Condition.create().eq("role_id", (Object)param.getRoleId()));
        if (result) {
            return BizResponse.success((Object)Boolean.TRUE);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse<Boolean> deleteUserMerchantChildrenRole(Long roleId) {
        FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
        obj.setIsDel(Integer.valueOf(1));
        obj.setRoleId(roleId);
        this.fbUserMerchantChildrenRoleService.update(obj, Condition.create().eq("role_id", (Object)roleId));
        return BizResponse.success((Object)Boolean.TRUE);
    }
}

