/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMercgantAuthenticationParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantAuthSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.FbMerchantAuthenticationResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantAuthListResult;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantAuthenticationService;
import com.fshows.lifecircle.user.service.business.db.IUserMerchantAuthService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbMerchantAuthenticationMapper;
import com.fshows.lifecircle.user.service.domain.po.FbMerchantAuthentication;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserMerchantAuthServiceImpl
implements IUserMerchantAuthService {
    private static final Logger log = LoggerFactory.getLogger(UserMerchantAuthServiceImpl.class);
    @Autowired
    IFbMerchantAuthenticationService merchantAuthenticationService;
    @Autowired
    FbMerchantAuthenticationMapper merchantAuthenticationMapper;

    @Override
    public BizResponse<FbMerchantAuthenticationResult> saveMerchantAuth(UserMercgantAuthenticationParam param) {
        FbMerchantAuthentication merchantAuthentication = (FbMerchantAuthentication)BijectionUtils.invert((Object)param, FbMerchantAuthentication.class);
        if (Objects.isNull(merchantAuthentication) || Objects.isNull(merchantAuthentication.getMid())) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbMerchantAuthentication record = (FbMerchantAuthentication)this.merchantAuthenticationService.selectOne(new EntityWrapper().eq("mid", (Object)merchantAuthentication.getMid()));
        if (Objects.isNull(record)) {
            if (Objects.isNull(merchantAuthentication.getAuthId())) {
                Long aLong = KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.COMMON_KEY);
                merchantAuthentication.setAuthId(aLong);
                this.merchantAuthenticationService.insert(merchantAuthentication);
            }
        } else {
            merchantAuthentication = BijectionUtils.invert((Object)param, record);
            this.merchantAuthenticationService.update(merchantAuthentication, new EntityWrapper().eq("auth_id", (Object)merchantAuthentication.getAuthId()));
        }
        FbMerchantAuthenticationResult result = (FbMerchantAuthenticationResult)BijectionUtils.invert((Object)merchantAuthentication, FbMerchantAuthenticationResult.class);
        return BizResponse.success((Object)result);
    }

    @Override
    public BizResponse<FbMerchantAuthenticationResult> getMerchantAuthDetail(Long mid) {
        FbMerchantAuthentication authentication = (FbMerchantAuthentication)this.merchantAuthenticationService.selectOne(new EntityWrapper().eq("mid", (Object)mid));
        if (Objects.isNull(authentication)) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbMerchantAuthenticationResult result = (FbMerchantAuthenticationResult)BijectionUtils.invert((Object)authentication, FbMerchantAuthenticationResult.class);
        return BizResponse.success((Object)result);
    }

    @Override
    public BizResponse<List<MerchantAuthListResult>> findFbMerchantAuthenticationResults(MerchantAuthSearchParam param) {
        Map<String, Object> paramMap = BijectionUtils.bean2Map(param);
        int startNum = (param.getPage() - 1) * param.getPageSize();
        paramMap.put("startNum", startNum);
        List mapRet = this.merchantAuthenticationMapper.selectListByCondition(paramMap);
        List<MerchantAuthListResult> listResults = BijectionUtils.mapsToObjects(mapRet, MerchantAuthListResult.class);
        return BizResponse.success(listResults);
    }
}

