/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemConfigParma;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemNodeRightParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.SearchOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemBindCardProtocolResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeListDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeRightDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemRightConfigDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.SearchOemDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.UserOemDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IOemService;
import com.fshows.lifecircle.user.service.business.db.IFbOemConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeRightService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightControlService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.domain.po.FbOemConfig;
import com.fshows.lifecircle.user.service.domain.po.FbOemNodeRight;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OemServiceImpl
implements IOemService {
    private static final Logger log = LoggerFactory.getLogger(OemServiceImpl.class);
    @Autowired
    IFbUserOemService oemService;
    @Autowired
    IFbUserBaseService baseService;
    @Autowired
    IFbOemConfigService configService;
    @Autowired
    IFbOemNodeService nodeService;
    @Autowired
    IFbOemNodeRightService nodeRightService;
    @Autowired
    IFbOemRightConfigService oemRightConfigService;
    @Autowired
    IFbOemRightControlService oemRightControlService;
    @Autowired
    IFbUserOemChildrenService oemChildrenService;
    @Autowired
    private IFbOemConfigService fbOemConfigService;

    @Override
    public BizResponse<UserOemDTO> addOem(AddOemParam param) {
        if (null == param.getBaseId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        if (null == this.baseService.selectOne(new EntityWrapper().eq("base_id", (Object)param.getBaseId()))) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USER_NOT_EXIST.getMsg());
        }
        if (null != this.oemService.selectOne(new EntityWrapper().eq("base_id", (Object)param.getBaseId()))) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_HAS_EXIST.getCode(), (String)ErrorCodeEnum.USER_HAS_EXIST.getMsg());
        }
        FbUserOem fbUserOem = new FbUserOem();
        BeanUtils.copyProperties((Object)param, (Object)fbUserOem);
        fbUserOem.setOemId(KeyGenerator.getKeyByType((KeyTypeEnum)KeyTypeEnum.OEM_USER_KEY));
        boolean inserted = this.oemService.insert(fbUserOem);
        if (inserted) {
            UserOemDTO oemDTO = (UserOemDTO)BijectionUtils.invert((Object)fbUserOem, UserOemDTO.class);
            return BizResponse.success((Object)oemDTO);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse<Boolean> updateOem(UpdateOemParam param) {
        FbUserOem oem = null;
        if (null != param.getOemId()) {
            oem = (FbUserOem)this.oemService.selectOne(new EntityWrapper().eq("oem_id", (Object)param.getOemId()));
        }
        if (null == oem) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USER_NOT_EXIST.getMsg());
        }
        BijectionUtils.invert((Object)param, oem);
        oem.setUpdateTime(null);
        boolean updateEd = this.oemService.updateById(oem);
        if (updateEd) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
    }

    @Override
    public BizResponse addOemConfig(AddOemConfigParma param) {
        FbOemConfig oemConfig;
        boolean inserted;
        if (null == param.getOemId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)param.getProtocolContent())) {
            param.setProtocolContent(" ");
        }
        if (inserted = this.configService.insert(oemConfig = (FbOemConfig)BijectionUtils.invert((Object)param, FbOemConfig.class))) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse<Boolean> updateOemConfig(UpdateOemConfigParam param) {
        if (null == param.getOemId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbOemConfig oemConfig = (FbOemConfig)BijectionUtils.invert((Object)param, FbOemConfig.class);
        boolean inserted = this.configService.update(oemConfig, new EntityWrapper().eq("oem_id", (Object)param.getOemId()));
        if (inserted) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse<PageResult<SearchOemDTO>> searchOem(SearchOemParam param) {
        if (null == param.getPage()) {
            param.setPage(Integer.valueOf(1));
        }
        if (null == param.getPageSize()) {
            param.setPageSize(Integer.valueOf(20));
        }
        Page oemPagez = this.oemService.selectPage(new Page(param.getPage().intValue(), param.getPageSize().intValue()), new EntityWrapper().ge(null != param.getCreateTime(), "create_time", (Object)param.getCreateTime()).like(null != param.getOemName(), "admin_title", param.getOemName()).orderBy(null != param.getIsAsc(), "create_time", param.getIsAsc().booleanValue()));
        List<SearchOemDTO> records = BijectionUtils.invertList(oemPagez.getRecords(), SearchOemDTO.class);
        int total = oemPagez.getTotal();
        PageResult pageResult = new PageResult(Integer.valueOf(total), records);
        return BizResponse.success((Object)pageResult);
    }

    @Override
    public BizResponse<OemResult> getOemByOemId(Long oemID) {
        if (1L == oemID) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbUserOem userOem = (FbUserOem)this.oemService.selectOne(new EntityWrapper().eq("oem_id", (Object)oemID));
        FbUserBase userBase = (FbUserBase)this.baseService.selectOne(new EntityWrapper().eq("base_id", (Object)userOem.getBaseId()));
        FbOemConfig oemConfig = (FbOemConfig)this.configService.selectOne(new EntityWrapper().eq("oem_id", (Object)oemID));
        OemResult oemResult = new OemResult();
        BijectionUtils.invert((Object)userOem, oemResult);
        BijectionUtils.invert((Object)oemConfig, oemResult);
        BijectionUtils.invert((Object)userBase, oemResult);
        return BizResponse.success((Object)oemResult);
    }

    @Override
    public BizResponse setOemNodeRight(AddOemNodeRightParam param) {
        if (null == param.getNodeId() || null == param.getOemId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbOemNodeRight hasOne = (FbOemNodeRight)this.nodeRightService.selectOne(new EntityWrapper().eq("node_id", (Object)param.getNodeId()).eq("oem_id", (Object)param.getOemId()));
        if (null != hasOne) {
            return BizResponse.fail((String)ErrorCodeEnum.NODE_HAS_EXIST.getCode(), (String)ErrorCodeEnum.NODE_HAS_EXIST.getMsg());
        }
        FbOemNodeRight nodeRight = (FbOemNodeRight)BijectionUtils.invert((Object)param, FbOemNodeRight.class);
        boolean insert = this.nodeRightService.insert(nodeRight);
        if (insert) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
    }

    @Override
    public BizResponse<List<OemNodeListDTO>> getNodez() {
        List nodeList = this.nodeService.selectList(new EntityWrapper().orderBy("level", true).orderBy("sort", true).orderBy("pid", true));
        List<OemNodeListDTO> oemNodeLists = BijectionUtils.invertList(nodeList, OemNodeListDTO.class);
        return BizResponse.success(oemNodeLists);
    }

    @Override
    public BizResponse<List<OemNodeRightDTO>> getOemNodeRightz(long oemId) {
        List<Map<String, Object>> maps = this.nodeRightService.selectOemRights(oemId);
        List<OemNodeRightDTO> oemNodeRightDTOS = BijectionUtils.mapsToObjects(maps, OemNodeRightDTO.class);
        return BizResponse.success(oemNodeRightDTOS);
    }

    @Override
    public BizResponse<List<OemRightConfigDTO>> getAllOemRight() {
        List fbOemRightConfigs = this.oemRightConfigService.selectList(new EntityWrapper().eq("status", (Object)1));
        List<OemRightConfigDTO> rightDTOS = BijectionUtils.invertList(fbOemRightConfigs, OemRightConfigDTO.class);
        return BizResponse.success(rightDTOS);
    }

    @Override
    public BizResponse<List<BaseInfo>> getOemListByOemId(Long oemId) {
        FbUserOem fbUserOem = (FbUserOem)this.oemService.selectOne(new EntityWrapper().eq("oem_id", (Object)oemId));
        List<Object> userIdAndName = new ArrayList();
        if (fbUserOem != null) {
            userIdAndName = this.oemChildrenService.getUserIdAndName(oemId);
        }
        FbUserBase fbUserBase = (FbUserBase)this.baseService.selectOne(new EntityWrapper().eq("base_id", (Object)fbUserOem.getBaseId()));
        BaseInfo baseInfo = (BaseInfo)BijectionUtils.invert((Object)fbUserBase, BaseInfo.class);
        userIdAndName.add(baseInfo);
        return BizResponse.success(userIdAndName);
    }

    @Override
    public BizResponse<List<BaseInfo>> getOemList() {
        List fbUserBases = this.baseService.selectList(new EntityWrapper().eq("user_type", (Object)UserType.OEM.getValue()));
        List<BaseInfo> baseInfos = BijectionUtils.invertList(fbUserBases, BaseInfo.class);
        return BizResponse.success(baseInfos);
    }

    @Override
    public OemBindCardProtocolResult getBindProtocol(Long oemId) {
        FbOemConfig fbOemConfig = (FbOemConfig)this.fbOemConfigService.selectOne(new EntityWrapper().eq("oem_id", (Object)oemId));
        if (fbOemConfig == null) {
            return null;
        }
        OemBindCardProtocolResult result = new OemBindCardProtocolResult();
        result.setAppBindText(fbOemConfig.getAppBindText());
        result.setProtocolContent(fbOemConfig.getProtocolContent());
        result.setProtocolTitle(fbOemConfig.getProtocolTitle());
        return result;
    }
}

