/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;


import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.IUserConstants;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.ChildrenRoleQuery;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenRoleParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 功能：子商户相关Service
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserMerchantChildrenRoleServiceImpl implements IUserMerchantChildrenRoleService {

  @Autowired
  private IFbUserBaseService fbUserBaseService;
  @Autowired
  private IFbUserOemService fbUserOemService;
  @Autowired
  private IFbUserAgentService fbUserAgentService;
  @Autowired
  private IFbUserMerchantService fbUserMerchantService;
  @Autowired
  private IFbUserMerchantChildrenService fbUserMerchantChildrenService;
  @Autowired
  private IFbUserMerchantChildrenRoleService fbUserMerchantChildrenRoleService;

  @Autowired
  private IUserBaseService userBaseService;

  @Autowired
  private FbUserMerchantMapper fbUserMerchantMapper;

  @Override
  public List<FbUserMerchantChildrenRole> getMerchantChildrenRoleListByCondition(ChildrenRoleQuery childrenRoleQuery) {
    List<FbUserMerchantChildrenRole> list = fbUserMerchantChildrenRoleService
            .selectList(Condition.create()
                    .eq(FbUserMerchantChildrenRole.MID, childrenRoleQuery.getMid())
                    .eq(FbUserMerchantChildrenRole.IS_DEL, 0)
                    .eq(FbUserMerchantChildrenRole.STATUS, 1)
                    .eq(childrenRoleQuery.getRoleType() != null, FbUserMerchantChildrenRole.ROLE_TYPE, childrenRoleQuery.getRoleType())
                    .like(childrenRoleQuery.getRoleName() != null, FbUserMerchantChildrenRole.NAME, childrenRoleQuery.getRoleName())
            );

    return list;
  }


  @Override
  public List<FbUserMerchantChildrenRole> getMerchantChildrenRoleList(Long mid, String roleName) {
    List<FbUserMerchantChildrenRole> list = fbUserMerchantChildrenRoleService
        .selectList(Condition.create()
            .eq(FbUserMerchantChildrenRole.MID, mid)
            .eq(FbUserMerchantChildrenRole.IS_DEL, 0)
            .eq(FbUserMerchantChildrenRole.STATUS, 1)
            .like(roleName != null, FbUserMerchantChildrenRole.NAME, roleName)
        );

    return list;
  }

  @Override
  public FbUserMerchantChildrenRole getMerchantChildrenRoleByRoleId(Long roleId) {
    FbUserMerchantChildrenRole obj = fbUserMerchantChildrenRoleService.selectOne(Condition.create()
        .eq(FbUserMerchantChildrenRole.ROLE_ID, roleId)
    );

    return obj;
  }


  @Override
  public BizResponse<Long> addUserMerchantChildrenRole(UserMerchantChildrenRoleParam param) {
    FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
    BeanUtils.copyProperties(param, obj);
    long businessUniqId = KeyGenerator.getKeyByType(KeyTypeEnum.MERCHANT_CHILDD_ROLE_KEY);
    obj.setRoleId(businessUniqId);

    boolean addResult = fbUserMerchantChildrenRoleService.insert(obj);

    if (addResult) {
      return BizResponse.success(businessUniqId);
    }

    return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(),
        ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());

  }

  @Override
  public BizResponse<Boolean> updateUserMerchantChildrenRole(UserMerchantChildrenRoleParam param) {
    FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
    BeanUtils.copyProperties(param, obj);

    boolean result = fbUserMerchantChildrenRoleService
        .update(obj, Condition.create().eq(FbUserMerchantChildrenRole.ROLE_ID, param.getRoleId()));

    if (result) {
      return BizResponse.success(Boolean.TRUE);
    }

    return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(),
        ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());

  }

  @Override
  public BizResponse<Boolean> deleteUserMerchantChildrenRole(Long roleId) {
    FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
    obj.setIsDel(IUserConstants.DELETE_STATUS);
    obj.setRoleId(roleId);

    fbUserMerchantChildrenRoleService
        .update(obj, Condition.create().eq(FbUserMerchantChildrenRole.ROLE_ID, roleId));

    return BizResponse.success(Boolean.TRUE);
  }


}
