/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.IUserConstants;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.db.*;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.business.utils.UserUtils;
import com.fshows.lifecircle.user.service.domain.po.FbRegisterDisallow;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserBaseServiceImpl implements IUserBaseService {

    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;

    @Autowired
    private IFbRegisterDisallowService registerDisallowService;

    @Override
    public BizResponse<UserBaseResult> addUserBase(UserBaseParam param) {
        UserBaseResult userBaseResult = new UserBaseResult();
        log.info("1, addUserBase execute >> para={}", JSON.toJSONString(param));
        try {

            if (isDisallow(param.getUsername())) {
                return BizResponse.fail(ErrorCodeEnum.USERNAME_HAS_DISALLOW.getCode(), ErrorCodeEnum.USERNAME_HAS_DISALLOW.getMsg());
            }

            // 查询用户信息
            int count = fbUserBaseService.selectCount(Condition.create().eq(FbUserBase.USERNAME, param.getUsername()));

            // 判断是否存在
            if (count > 0) {
                log.info("1, addUserBase username exist >> usernanme={}", param.getUsername());
                return BizResponse.fail(ErrorCodeEnum.USER_HAS_EXIST.getCode(), ErrorCodeEnum.USER_HAS_EXIST.getMsg());
            }

            FbUserBase obj = new FbUserBase();
            BeanUtils.copyProperties(param, obj);

            // 生成业务id
            long baseId = KeyGenerator.getKeyByType(KeyTypeEnum.BASE_USER_KEY);

            obj.setBaseId(baseId);

            //密码 md5
            String salt = UserUtils.generatorSalt();

            String userMd5Pwd = SecureUtil.md5(param.getUserpwd() + salt);
            obj.setUserpwd(userMd5Pwd);
            obj.setSalt(salt);
            obj.setStatus(IUserConstants.USER_BASE_STATUS_OK);

            boolean addResult = fbUserBaseService.insert(obj);

            if (addResult) {
                userBaseResult.setBaseId(baseId);
                log.info("2, addUserBase success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(userBaseResult);
            }

            log.info("3, addUserBase fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: addUserBase 发生异常， 参数: userBaseParam = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }

    }


    @Override
    public BizResponse<Boolean> updateUserBase(UserBaseParam param) {
        log.info("1, updateUserBase execute >> para={}", JSON.toJSONString(param));
        long baseId = param.getBaseId();
        try {

            if (isDisallow(param.getUsername())) {
                return BizResponse.fail(ErrorCodeEnum.USERNAME_HAS_DISALLOW.getCode(), ErrorCodeEnum.USERNAME_HAS_DISALLOW.getMsg());
            }

            // 查询用户信息
            int count = fbUserBaseService.selectCount(Condition.create()
                    .eq(FbUserBase.USERNAME, param.getUsername()).ne(FbUserBase.BASE_ID, baseId));

            // 判断是否存在
            if (count > 0) {
                log.info("1, updateUserBase username exist >> usernanme={}", param.getUsername());
                return BizResponse.fail(ErrorCodeEnum.USER_HAS_EXIST.getCode(), ErrorCodeEnum.USER_HAS_EXIST.getMsg());
            }

            FbUserBase obj = new FbUserBase();
            BeanUtils.copyProperties(param, obj);

            if (StringUtils.isNotBlank(param.getUserpwd())) {
                //密码 md5
                String salt = UserUtils.generatorSalt();
                String userMd5Pwd = SecureUtil.md5(param.getUserpwd() + salt);
                obj.setUserpwd(userMd5Pwd);
                obj.setSalt(salt);
            }

            boolean updateResult = fbUserBaseService.update(obj, Condition.create().eq(FbUserBase.BASE_ID, baseId));

            if (updateResult) {
                log.info("2, updateUserBase success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(Boolean.TRUE);
            }

            log.info("3, addUserBase fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: updateUserBase 发生异常， 参数: userBaseParam = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<Boolean> deleteUserBase(Long baseId) {
        log.info("1, deleteUserBase execute >> baseId={}", baseId);
        try {

            FbUserBase obj = new FbUserBase();
            obj.setIsDel(IUserConstants.DELETE_STATUS);
            obj.setBaseId(baseId);

            boolean result = fbUserBaseService.update(obj, Condition.create().eq(FbUserBase.BASE_ID, baseId));

            if (result) {
                log.info("2, deleteUserBase success >> baseId={}", baseId);

                return BizResponse.success(Boolean.TRUE);
            }

            log.info("3, deleteUserBase fail >> baseId={}", baseId);

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: deleteUserBase 发生异常， 参数: baseId = {} ,异常: Ex = {}", baseId,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    @Override
    public BizResponse<BaseInfo> getUserBaseByUsername(String username) {


        FbUserBase fbUserBase = fbUserBaseService.selectOne(Condition.create().eq(FbUserBase.USERNAME, username));

        BaseInfo baseInfo = BijectionUtils.invert(fbUserBase, BaseInfo.class);


        return BizResponse.success(baseInfo);
    }

    @Override
    public BizResponse<BaseInfo> getUserBaseByBaseId(Long baseId) {
        try {

            FbUserBase fbUserBase = fbUserBaseService.selectOne(Condition.create().eq(FbUserBase.BASE_ID, baseId));

            BaseInfo baseInfo = BijectionUtils.invert(fbUserBase, BaseInfo.class);

            return BizResponse.success(baseInfo);


        } catch (Exception e) {
            log.error("方法: getUserBaseByBaseId 发生异常， 参数: baseId = {} ,异常: Ex = {}", baseId,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
        }
    }

    private boolean isDisallow(String userName) {
        int count = registerDisallowService.selectCount(Condition.create().eq(FbRegisterDisallow.NAME, userName));
        return count > 0;
    }


}
