/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleUserAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleUserQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.RoleUserResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IRoleUserService;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemChildrenService;
import com.fshows.lifecircle.user.service.dao.FbUserOemChildrenMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserOemChildren;
import com.fshows.lifecircle.user.service.domain.po.RoleUserPO;
import com.fshows.lifecircle.user.service.domain.query.RoleUserQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-18 14:59
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class RoleUserService implements IRoleUserService {

  @Autowired
  private IFbUserOemChildrenService fbUserOemChildrenService;
  @Autowired
  private FbUserOemChildrenMapper fbUserOemChildrenMapper;
  @Autowired
  private IUserBaseService userBaseService;

  /**
   * 添加或修改管理员
   */
  @Override
  public Boolean addOrUpdateRoleUser(RoleUserAddOrUpdateParam param) {

    UserBaseParam userBaseParam = new UserBaseParam();
    userBaseParam.setUsername(param.getUsername());
    userBaseParam.setUserpwd(param.getPassword());
    userBaseParam.setMobile(param.getPhone());
    userBaseParam.setUserType(UserType.OEM.getValue());
    userBaseParam.setIsChild(1);
    userBaseParam.setStatus(param.getStatus());


    //---------------------- 修改 ----------------------
    if (param.getUserId() != null) {

      userBaseParam.setBaseId(param.getUserId());

      // 修改基础用户
      BizResponse<Boolean> booleanBizResponse = userBaseService.updateUserBase(userBaseParam);

      boolean b = booleanBizResponse.isSuccess() && booleanBizResponse.getData();

      // 修改子账号
      boolean update = fbUserOemChildrenService.update(
          new FbUserOemChildren().setIsDel(param.getIsDel()).setLinkman(param.getLinkman())
              .setRoleId(param.getRoleId()),
          new EntityWrapper<FbUserOemChildren>().eq(FbUserOemChildren.BASE_ID, param.getUserId()));

      return update || b;
    }

    //---------------------- 添加 ----------------------
    // 添加基础用户

    BizResponse<UserBaseResult> response = userBaseService
        .addUserBase(userBaseParam);
    if (!response.isSuccess()) {

      return false;
    }

    return fbUserOemChildrenService.insert(
        new FbUserOemChildren().setOemId(param.getOemId()).setRoleId(param.getRoleId()).setLinkman(param.getLinkman())
            .setBaseId(response.getData().getBaseId()));
  }

  /**
   * 查询管理员列表
   */
  @Override
  public PageResult<RoleUserResult> findListByPage(RoleUserQueryParam param) {

    // 查询参数
    RoleUserQuery roleUserQuery = new RoleUserQuery();
    BeanUtils.copyProperties(param, roleUserQuery);

    // 分页参数计算
    roleUserQuery.setPageStart((param.getPage() - 1) * param.getPageSize());

    // 查询总条数
    Integer listByPageCount = fbUserOemChildrenMapper.findListByPageCount(roleUserQuery);
    if (listByPageCount == 0) {

      return null;
    }

    List<RoleUserPO> list = fbUserOemChildrenMapper.findListByPage(roleUserQuery);

    return new PageResult<RoleUserResult>(listByPageCount, list.stream().map(po -> {
      RoleUserResult roleUserResult = new RoleUserResult();
      BeanUtils.copyProperties(po, roleUserResult);
      return roleUserResult;
    }).collect(Collectors.toList()));
  }
}
