/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeRightDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.CollectionUtils;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.dao.FbOemNodeMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemNode;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.query.OemNodeQuery;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-19 09:56
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class OemNodeService implements IOemNodeService {

    @Autowired
    private IFbOemNodeService oemNodeService;
    @Autowired
    private FbOemNodeMapper oemNodeMapper;
    @Autowired
    private IFbUserBaseService userBaseService;

    /**
     * 添加或修改 oem 节点对象
     */
    @Override
    public Boolean addAndUpdateOemNode(OemNodeAddOrUpdateParam param) {

        FbOemNode fbOemNode = new FbOemNode();
        BeanUtils.copyProperties(param, fbOemNode);

        // 修改
        if (param.getNodeId() != null) {

            fbOemNode.setNodeId(null);
            return oemNodeService.update(fbOemNode,
                    new EntityWrapper<FbOemNode>().eq(FbOemNode.NODE_ID, param.getNodeId()));
            // 添加
        } else {

            fbOemNode.setNodeId(KeyGenerator.getKeyByType());
            return oemNodeService.insert(fbOemNode);
        }
    }

    /**
     * oem 节点列表接口
     */
    @Override
    public List<OemNodeResult> findByPage(OemNodeQueryParam param) {

        OemNodeQuery oemNodeQuery = new OemNodeQuery();
        BeanUtils.copyProperties(param, oemNodeQuery);

        return oemNodeMapper.findAllBySort(oemNodeQuery).stream().map(oemNode -> {
            OemNodeResult result = new OemNodeResult();
            BeanUtils.copyProperties(oemNode, result);
            return result;
        }).collect(Collectors.toList());
    }

    @Override
    public BizResponse<List<OemNodeRightDTO>> findALL() {

        List<FbOemNode> fbOemNodes = oemNodeMapper.selectList(
                new EntityWrapper<FbOemNode>()
                        .eq(FbOemNode.IS_DEL, 0)
                        .orderBy(FbOemNode.SORT, false)
        );

        List<OemNodeRightDTO> oemNodeRightDTOS = BijectionUtils
                .invertList(fbOemNodes, OemNodeRightDTO.class);

        return BizResponse.success(CollectionUtils.safe(oemNodeRightDTOS));


    }


    /**
     * 获得详情
     */
    @Override
    public OemNodeDetailResult getById(Long id) {

        FbOemNode fbOemNode = oemNodeService.selectOne(
                new EntityWrapper<FbOemNode>().eq(FbOemNode.IS_DEL, 0).eq(FbOemNode.NODE_ID, id));

        if (fbOemNode != null) {

            OemNodeDetailResult result = OemNodeDetailResult.builder().build();
            BeanUtils.copyProperties(fbOemNode, result);
            if (result.getPid() == 0L) {

                result.setPidName("根结点");
            } else {

                FbOemNode pNode = oemNodeService.selectOne(
                        new EntityWrapper<FbOemNode>().eq(FbOemNode.IS_DEL, 0)
                                .eq(FbOemNode.NODE_ID, fbOemNode.getPid()));
                result.setPidName(pNode.getTitle());
            }

            return result;
        }
        return null;
    }
}
