/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LogParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LogQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.FbOperateLogResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.ILogService;
import com.fshows.lifecircle.user.service.business.db.IFbOperateLogService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.domain.po.FbOperateLog;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@Slf4j
@Service
public class LogServiceImpl implements ILogService {

    @Autowired
    IFbOperateLogService operateLogService;

    @Override
    public BizResponse<Boolean> saveLog(LogParam param) {


        FbOperateLog operateLog = BijectionUtils.invert(param, FbOperateLog.class);

        return BizResponse.success(operateLogService.insert(operateLog));
    }

    @Override
    public BizResponse<  PageResult<FbOperateLogResult>> logQuery(LogQueryParam param) {

        RowBounds rowBounds = new RowBounds();

        Page<FbOperateLog> page = new Page(param.getPage(), param.getPageSize());
        operateLogService.selectPage(page,
                new EntityWrapper<FbOperateLog>()
                        .eq(param.getOperator() != null, FbOperateLog.USER_ID, param.getOperator())
                        .eq(param.getOperateMode() != null, FbOperateLog.OPERATE_MODULE, param.getOperateMode())
                        .ge(param.getStartTime() != null, FbOperateLog.CREATE_TIME, new Date(Optional.ofNullable(param.getStartTime()).orElse(0L)))
                        .le(param.getEndTime() != null, FbOperateLog.CREATE_TIME,new Date(Optional.ofNullable(param.getEndTime()).orElse(0L))));


        List<FbOperateLog> records = page.getRecords();


        List<FbOperateLogResult> logResults = BijectionUtils.invertList(records, FbOperateLogResult.class);

        PageResult<FbOperateLogResult> pageResult = new PageResult<>(page.getTotal(), logResults);

        return BizResponse.success(pageResult);


    }

    public static void main(String[] args) {
        new Date(0L);
    }
}
