/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.utils;

import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import lombok.experimental.UtilityClass;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.utils
 * 功能： 用户工具类
 * 创建时间：2017-12-06 14:19
 * 更新记录：
 *
 * @author BuHao
 */
@UtilityClass
public class UserUtils {

  /**
   * 获得加密用的 salt salt
   */
  public String generatorSalt() {

    return RandomUtil.randomString(12);
  }

  /**
   * 获得 md5后的密码
   *
   * @param pwd 密码明文
   * @param salt 加密 salt
   */
  public String getPwdByMd5(String pwd, String salt) {

    return SecureUtil.md5(pwd + salt);
  }
}
