package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantRightControlService;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbMerchantRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbMerchantRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 商户权限配置信息 服务实现类
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@Service
@Slf4j
public class FbMerchantRightControlServiceImpl extends ServiceImpl<FbMerchantRightControlMapper, FbMerchantRightControl> implements
    IFbMerchantRightControlService {

    @Autowired
    private FbMerchantRightControlMapper fbMerchantRightControlMapper;

    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    /**
     * 新增或修改OEM权限
     * @param userId
     * @param array
     * @return
     */
    @Override
    public BizResponse<Boolean> updateMerchantRightControl(Long userId, String[] array) {
        FbMerchantRightControl fbMerchantRightControl;
        log.info("updateMerchantRightControl execute >> userId={}, array = {}", userId, array);
        try {
            //检查userId 是否合规
            FbUserMerchant fbUserMerchant = new FbUserMerchant();
            fbUserMerchant.setMid(userId);
            fbUserMerchant = fbUserMerchantMapper.selectOne(fbUserMerchant);
            if (userId == null || array == null || fbUserMerchant == null) {
                log.info("2.3.9 - 1, updateOemRightControl check fail, userId or array can not be null");
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            //1、查询是否存在权限
            List<FbMerchantRightControl> fbMerchantRightControlList = fbMerchantRightControlMapper.selectCountByUserId(userId);
            log.info("2.3.9 - 2, updateMerchantRightControl 存储历史数据 fbAgentRightControlList = {}", JSON.toJSONString(fbMerchantRightControlList));

            //2、如果存在权限，将旧权限全部删除
            if (fbMerchantRightControlList.size() > 0) {
                fbMerchantRightControlMapper.deleteByUserId(userId);
            }

            //3、重新创建新的权限
            Integer i = 0;
            for (String s : array) {
                fbMerchantRightControl = new FbMerchantRightControl();
                long businessUniqId = KeyGenerator.getKeyByType(KeyTypeEnum.CONTROL_KEY);
                fbMerchantRightControl.setId(businessUniqId);
                fbMerchantRightControl.setMid(userId);
                fbMerchantRightControl.setRightKey(s);
                fbMerchantRightControl.setIsOpen(1);
                fbMerchantRightControl.setCreateTime(new Date());
                fbMerchantRightControl.setUpdateTime(new Date());
                Integer addResultCount = fbMerchantRightControlMapper.insert(fbMerchantRightControl);
                i = i + addResultCount;
            }

            //4、添加失败删除 回滚数据
            if (i != array.length) {
                fbMerchantRightControlMapper.deleteByUserId(userId);
                if (fbMerchantRightControlList != null && fbMerchantRightControlList.size() > 0) {
                    for (FbMerchantRightControl control : fbMerchantRightControlList) {
                        fbMerchantRightControlMapper.insert(control);
                    }
                }
                return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(),ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }

            return BizResponse.success(Boolean.TRUE);

        } catch (Exception e) {
            log.error("2.3.9 - 3, 方法: updateMerchantRightControl 发生异常， 参数: userId = {}, array = {},异常: Ex = {}", userId, array,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }
}
