/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;


import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.IUserConstants;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.app.StaffListParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffListResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.*;
import com.fshows.lifecircle.user.service.domain.query.StaffListQuery;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 功能：子商户相关Service
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserMerchantChildrenServiceImpl implements IUserMerchantChildrenService {

    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbUserMerchantChildrenService fbUserMerchantChildrenService;
    @Autowired
    private IFbUserMerchantChildrenRoleService fbUserMerchantChildrenRoleService;

    @Autowired
    private IUserBaseService userBaseService;

    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;


    @Override
    public BizResponse<Boolean> addUserMerchantChildren(UserMerchantChildrenParam param) {

        String username = param.getUsername();
        //username  格式： 员工账号@老板账号

        UserBaseParam userBaseParam = new UserBaseParam();

        userBaseParam.setUsername(username);
        userBaseParam.setUserpwd(param.getUserpwd());
        userBaseParam.setMobile(param.getMobile());
        userBaseParam.setUserType(UserType.MERCHANT.getValue());
        userBaseParam.setIsChild(1);

        //---------------------- 添加 基础用户----------------------
        BizResponse<UserBaseResult> response = userBaseService.addUserBase(userBaseParam);
        if (!response.isSuccess()) {
            return BizResponse.fail(response.getErrorCode(), response.getErrorMessage());
        }

        Long baseId = response.getData().getBaseId();


        //---------------------- 添加 商户子商户----------------------
        FbUserMerchantChildren obj = new FbUserMerchantChildren();
        BeanUtils.copyProperties(param, obj);
        obj.setBaseId(baseId);

        boolean result = fbUserMerchantChildrenService.insert(obj);

        if (result) {
            //成功添加
            return BizResponse.success(Boolean.TRUE);
        } else {
            //失败 删除基础用户表中的数据
            fbUserBaseService.delete(Condition.create().eq(FbUserBase.BASE_ID, param.getBaseId()));
        }

        return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());

    }

    @Override
    public BizResponse<Boolean> updateUserMerchantChildren(UserMerchantChildrenParam param) {
        FbUserMerchantChildren obj = new FbUserMerchantChildren();
        BeanUtils.copyProperties(param, obj);

        if (param.getBaseId() == null || param.getBaseId().longValue() <= 0) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }

        //---------------------- 修改 基础用户----------------------
        UserBaseParam userBaseParam = new UserBaseParam();
        userBaseParam.setBaseId(param.getBaseId());
        userBaseParam.setUsername(param.getUsername());
        userBaseParam.setUserpwd(param.getUserpwd());
        userBaseParam.setMobile(param.getMobile());
        userBaseParam.setUserType(UserType.MERCHANT.getValue());
        userBaseService.updateUserBase(userBaseParam);

        //---------------------- 修改 商户子账号----------------------

        fbUserMerchantChildrenService.update(obj, Condition.create().eq(FbUserMerchantChildren.BASE_ID, param.getBaseId()));

        return BizResponse.success(Boolean.TRUE);

    }


    @Override
    public BizResponse<MerchantChildDetailsResult> getUserMerchantChild(MerchantChildQueryParam param) {


        boolean b = Objects.nonNull(param.getOemId()) || Objects.nonNull(param.getBaseId());

        if (!b) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }

        FbUserMerchantChildren merchantChildren = fbUserMerchantChildrenService.selectOne(
                new EntityWrapper<FbUserMerchantChildren>()
                        .eq(Objects.nonNull(param.getBaseId()), FbUserOemChildren.BASE_ID, param.getBaseId())
                        .like(StringUtils.isNotBlank(param.getLinkMan()), FbUserOemChildren.LINKMAN, param.getLinkMan())
                        .eq(Objects.nonNull(param.getOemId()), FbUserOemChildren.OEM_ID, param.getOemId()));


        if (!Objects.nonNull(merchantChildren)) {
            return BizResponse.success(null);
        }

        FbUserBase fbUserBase = fbUserBaseService.selectOne(Condition.create()
                .eq(FbUserOemChildren.BASE_ID, merchantChildren.getBaseId()));

        MerchantChildDetailsResult detailsResult = new MerchantChildDetailsResult();

        BijectionUtils.invert(merchantChildren, detailsResult);
        BijectionUtils.invert(fbUserBase, detailsResult);

        return BizResponse.success(detailsResult);


    }

    @Override
    public BizResponse<Boolean> deleteUserMerchantChildrenByBaseId(Long baseId) {
        //---------------------- 修改 基础用户删除状态----------------------
        FbUserBase userBaseParam = new FbUserBase();
        userBaseParam.setIsDel(IUserConstants.DELETE_STATUS);
        userBaseParam.setBaseId(baseId);

        fbUserBaseService.update(userBaseParam, Condition.create().eq(FbUserBase.BASE_ID, baseId));

        //---------------------- 修改 员工删除状态----------------------
        FbUserMerchantChildren obj = new FbUserMerchantChildren();
        obj.setBaseId(baseId);
        obj.setIsDel(IUserConstants.DELETE_STATUS);
        fbUserMerchantChildrenService.update(obj, Condition.create().eq(FbUserBase.BASE_ID, baseId));

        return BizResponse.success(Boolean.TRUE);
    }

    @Override
    public BizResponse<MerchantChildrenDetailDTO> getUserMerchantChildrenByBaseId(Long baseId) {

         /*merchantChildrenDetailDTO  包含用户基础信息  和 子商户信息*/
        MerchantChildrenDetailDTO merchantChildrenDetailDTO = new MerchantChildrenDetailDTO();


        FbUserMerchantChildren fbUserMerchantChildren = fbUserMerchantChildrenService.selectOne(Condition.create().eq(FbUserOemChildren.BASE_ID, baseId));
        MerchantChildrenResult merchantChildrenResult = BijectionUtils.invert(fbUserMerchantChildren, MerchantChildrenResult.class);

        if (merchantChildrenResult != null) {
            FbUserBase fbUserBase = fbUserBaseService.selectOne(Condition.create().eq(FbUserBase.BASE_ID, merchantChildrenResult.getBaseId()));
            BaseInfo baseInfo = BijectionUtils.invert(fbUserBase, BaseInfo.class);
            merchantChildrenDetailDTO.setBaseInfo(baseInfo);
        }

        merchantChildrenDetailDTO.setMerchantChildrenResult(merchantChildrenResult);

        return BizResponse.success(merchantChildrenDetailDTO);

    }

    @Override
    public BizResponse<PageResult<StaffListResult>> getStaffListResult(StaffListParam param) {
        PageResult<StaffListResult> staffListQueries = fbUserMerchantChildrenService.getStaffListResult(param);
        return BizResponse.success(staffListQueries);
    }

    @Override
    public BizResponse<StaffDetailResult> getStaffDetailResult(Long uid) {
        StaffDetailResult staffDetailResult = fbUserMerchantChildrenService.getStaffDetailResult(uid);
        return BizResponse.success(staffDetailResult);
    }
}
